% oauth2create(1) | User Commands
%
% "06/06/2023"

# NAME

oauth2create - program to obtain and store the oauth2 credential

# SYNOPSIS

**oauth2create** {_app_} {_user_}

**oauth2create** [{**-h** | **\-\-help**}]

# DESCRIPTION

This manual page documents briefly the **oauth2create** command.

This manual page was written for the Debian distribution because the
original program does not have a manual page.

**oauth2create** is a program to obtain the OAuth2 credential. It
will output a link for users to click. The link will authorize the permission
to obtain an oauth2 credential. And then the credential will be stored.

# OPTIONS

The program follows the usual GNU command line syntax, with long options
starting with two dashes ('-'). A summary of options is included below.

_app_
:   The name of the app.

_user_
:   The name of the user.

**-h**, **\-\-help**
:   Show summary of options.

# FILES

${HOME}/.config/oauth2token/{_app_}/config.json
:   The secret and token of the app. This information is needed to talk to
    the API provider.

${HOME}/.config/oauth2token/{_app_}/scopes.json
:   The scope of the API.

# BUGS

The upstream BTS can be found at https://github.com/VannTen/oauth2token/issues

# SEE ALSO

**oauth2get**(1)

# AUTHOR

Ying-Chun Liu (PaulLiu) <paulliu@debian.org>
:   Wrote this manpage for the Debian system.

# COPYRIGHT

Copyright © 2023 Ying-Chun Liu (PaulLiu) <paulliu@debian.org>

This manual page was written for the Debian system (and may be used by
others).

Permission is granted to copy, distribute and/or modify this document under
the terms of the GNU General Public License, Version 2 or (at your option)
any later version published by the Free Software Foundation.

On Debian systems, the complete text of the GNU General Public License
can be found in /usr/share/common-licenses/GPL-2.
