from __future__ import absolute_import, division, print_function
import iotbx.pdb
import iotbx.pdb.amino_acid_codes

ala_h = """
CRYST1   22.664   22.687   23.318  90.00  90.00  90.00 P 1
ATOM      1  N   ALA            12.208  10.150  12.482  1.00  0.00           N
ATOM      2  CA  ALA            11.068  11.053  12.388  1.00  0.00           C
ATOM      3  C   ALA            10.345  10.870  11.059  1.00  0.00           C
ATOM      4  O   ALA            10.972  10.843   9.999  1.00  0.00           O
ATOM      5  CB  ALA            11.525  12.494  12.548  1.00  0.00           C
ATOM      6  H   ALA            12.574   9.969  11.725  1.00  0.00           H
ATOM      7  HA  ALA            10.443  10.853  13.103  1.00  0.00           H
ATOM      8  HB1 ALA            11.946  12.597  13.415  1.00  0.00           H
ATOM      9  HB2 ALA            12.159  12.704  11.845  1.00  0.00           H
ATOM     10  HB3 ALA            10.753  13.078  12.482  1.00  0.00           H
TER
END
"""

ala = """
CRYST1   22.664   22.687   23.318  90.00  90.00  90.00 P 1
ATOM         N   ALA            12.209  10.151  12.481  1.00  0.00           N
ATOM         CA  ALA            11.069  11.055  12.388  1.00  0.00           C
ATOM         C   ALA            10.347  10.872  11.058  1.00  0.00           C
ATOM         O   ALA            10.973  10.843   9.999  1.00  0.00           O
ATOM         CB  ALA            11.525  12.496  12.547  1.00  0.00           C
TER
END
"""

arg_h = """
CRYST1   25.402   27.627   23.258  90.00  90.00  90.00 P 1
ATOM         N   ARG            12.731  16.982  12.482  1.00  0.00           N
ATOM         CA  ARG            13.349  15.664  12.419  1.00  0.00           C
ATOM         C   ARG            14.865  15.774  12.534  1.00  0.00           C
ATOM         O   ARG            15.402  16.855  12.775  1.00  0.00           O
ATOM         CB  ARG            12.977  14.962  11.110  1.00  0.00           C
ATOM         CG  ARG            11.482  14.715  10.929  1.00  0.00           C
ATOM         CD  ARG            10.967  13.561  11.786  1.00  0.00           C
ATOM         NE  ARG            11.479  12.262  11.342  1.00  0.00           N
ATOM         CZ  ARG            12.518  11.607  11.866  1.00  0.00           C
ATOM         NH1 ARG            13.222  12.090  12.890  1.00  0.00           N
ATOM         NH2 ARG            12.863  10.434  11.352  1.00  0.00           N
ATOM         H   ARG            13.262  17.627  12.277  1.00  0.00           H
ATOM         HA  ARG            13.024  15.119  13.166  1.00  0.00           H
ATOM         HB2 ARG            13.275  15.511  10.369  1.00  0.00           H
ATOM         HB3 ARG            13.425  14.102  11.080  1.00  0.00           H
ATOM         HG2 ARG            11.309  14.499  10.000  1.00  0.00           H
ATOM         HG3 ARG            10.995  15.516  11.179  1.00  0.00           H
ATOM         HD2 ARG            10.000  13.533  11.716  1.00  0.00           H
ATOM         HD3 ARG            11.221  13.702  12.710  1.00  0.00           H
ATOM         HE  ARG            11.073  11.887  10.683  1.00  0.00           H
ATOM        HH11 ARG            13.882  11.630  13.193  1.00  0.00           H
ATOM        HH12 ARG            13.040  12.842  13.258  1.00  0.00           H
ATOM        HH21 ARG            13.530  10.000  11.680  1.00  0.00           H
ATOM        HH22 ARG            12.421  10.106  10.692  1.00  0.00           H
TER
END
"""

arg = """
CRYST1   25.402   27.627   23.258  90.00  90.00  90.00 P 1
ATOM         N   ARG            12.731  16.982  12.482  1.00 10.00           N
ATOM         CA  ARG            13.349  15.664  12.419  1.00 10.00           C
ATOM         C   ARG            14.865  15.774  12.534  1.00 10.00           C
ATOM         O   ARG            15.402  16.855  12.775  1.00 10.00           O
ATOM         CB  ARG            12.977  14.962  11.110  1.00 10.00           C
ATOM         CG  ARG            11.482  14.715  10.929  1.00 10.00           C
ATOM         CD  ARG            10.967  13.561  11.786  1.00 10.00           C
ATOM         NE  ARG            11.479  12.262  11.342  1.00 10.00           N
ATOM         CZ  ARG            12.518  11.607  11.866  1.00 10.00           C
ATOM         NH1 ARG            13.222  12.090  12.890  1.00 10.00           N
ATOM         NH2 ARG            12.863  10.434  11.352  1.00 10.00           N
TER
END
"""

asn_h = """
CRYST1   23.559   24.773   24.641  90.00  90.00  90.00 P 1
ATOM         N   ASN            10.214  11.918  12.863  1.00  0.00           N
ATOM         CA  ASN            11.393  12.766  12.988  1.00  0.00           C
ATOM         C   ASN            11.281  14.013  12.118  1.00  0.00           C
ATOM         O   ASN            10.740  13.964  11.013  1.00  0.00           O
ATOM         CB  ASN            12.652  11.983  12.612  1.00  0.00           C
ATOM         CG  ASN            12.869  10.770  13.495  1.00  0.00           C
ATOM         OD1 ASN            11.941  10.284  14.141  1.00  0.00           O
ATOM         ND2 ASN            14.101  10.275  13.528  1.00  0.00           N
ATOM         H   ASN             9.484  12.293  13.120  1.00  0.00           H
ATOM         HA  ASN            11.482  13.054  13.920  1.00  0.00           H
ATOM         HB2 ASN            13.424  12.563  12.702  1.00  0.00           H
ATOM         HB3 ASN            12.572  11.676  11.695  1.00  0.00           H
ATOM        HD21 ASN            14.276   9.588  14.015  1.00  0.00           H
ATOM        HD22 ASN            14.724  10.642  13.063  1.00  0.00           H
TER
END
"""

asn = """
CRYST1   23.559   24.773   24.641  90.00  90.00  90.00 P 1
ATOM         N   ASN            10.214  11.918  12.863  1.00  0.00           N
ATOM         CA  ASN            11.393  12.766  12.988  1.00  0.00           C
ATOM         C   ASN            11.281  14.013  12.118  1.00  0.00           C
ATOM         O   ASN            10.740  13.964  11.013  1.00  0.00           O
ATOM         CB  ASN            12.652  11.983  12.612  1.00  0.00           C
ATOM         CG  ASN            12.869  10.770  13.495  1.00  0.00           C
ATOM         OD1 ASN            11.941  10.284  14.141  1.00  0.00           O
ATOM         ND2 ASN            14.101  10.275  13.528  1.00  0.00           N
TER
END
"""

asp_h = """
CRYST1   24.331   23.901   23.964  90.00  90.00  90.00 P 1
ATOM         N   ASP             9.845  11.565  11.028  1.00  0.00           N
ATOM         CA  ASP            10.952  11.701  11.966  1.00  0.00           C
ATOM         C   ASP            10.669  12.803  12.980  1.00  0.00           C
ATOM         O   ASP            10.510  13.968  12.616  1.00  0.00           O
ATOM         CB  ASP            12.250  12.005  11.215  1.00  0.00           C
ATOM         CG  ASP            13.440  12.152  12.144  1.00  0.00           C
ATOM         OD1 ASP            14.076  11.187  12.405  1.00  0.00           O
ATOM         OD2 ASP            13.731  13.361  12.617  1.00  0.00           O
ATOM         H   ASP            10.044  11.133  10.312  1.00  0.00           H
ATOM         HA  ASP            11.068  10.867  12.448  1.00  0.00           H
ATOM         HB2 ASP            12.145  12.835  10.726  1.00  0.00           H
ATOM         HB3 ASP            12.437  11.278  10.601  1.00  0.00           H
ATOM         HD2 ASP            13.087  13.974  12.287  1.00  0.00           H
TER
END
"""

asp = """
CRYST1   24.331   23.901   23.964  90.00  90.00  90.00 P 1
ATOM         N   ASP            10.032  11.934  11.014  1.00  0.00           N
ATOM         CA  ASP            11.142  11.756  11.942  1.00  0.00           C
ATOM         C   ASP            11.152  12.864  12.989  1.00  0.00           C
ATOM         O   ASP            10.545  13.918  12.798  1.00  0.00           O
ATOM         CB  ASP            12.471  11.744  11.185  1.00  0.00           C
ATOM         CG  ASP            13.663  11.563  12.104  1.00  0.00           C
ATOM         OD1 ASP            14.056  10.402  12.348  1.00  0.00           O
ATOM         OD2 ASP            14.208  12.580  12.582  1.00  0.00           O
TER
END
"""

cys_h = """
CRYST1   22.148   23.227   25.463  90.00  90.00  90.00 P 1
ATOM      1  N   CYS             9.145  11.906  12.895  1.00  0.00           N
ATOM      2  CA  CYS            10.591  11.757  12.789  1.00  0.00           C
ATOM      3  C   CYS            11.229  11.684  14.172  1.00  0.00           C
ATOM      4  O   CYS            11.131  12.623  14.962  1.00  0.00           O
ATOM      5  CB  CYS            11.190  12.923  12.001  1.00  0.00           C
ATOM      6  SG  CYS            10.562  13.076  10.312  1.00  0.00           S
ATOM      7  H   CYS             8.791  11.444  13.528  1.00  0.00           H
ATOM      8  HA  CYS            10.794  10.934  12.317  1.00  0.00           H
ATOM      9  HB2 CYS            10.988  13.749  12.467  1.00  0.00           H
ATOM     10  HB3 CYS            12.151  12.802  11.949  1.00  0.00           H
ATOM     11  HG  CYS            10.815  12.070   9.709  1.00  0.00           H
TER
END
"""

cys = """
CRYST1   22.148   23.227   25.463  90.00  90.00  90.00 P 1
ATOM         N   CYS             9.141  11.902  12.891  1.00  0.00           N
ATOM         CA  CYS            10.587  11.755  12.790  1.00  0.00           C
ATOM         C   CYS            11.220  11.681  14.174  1.00  0.00           C
ATOM         O   CYS            11.156  12.635  14.949  1.00  0.00           O
ATOM         CB  CYS            11.187  12.923  12.005  1.00  0.00           C
ATOM         SG  CYS            10.565  13.078  10.314  1.00  0.00           S
TER
END
"""

gln_h = """
CRYST1   25.084   23.384   24.805  90.00  90.00  90.00 P 1
ATOM         N   GLN            12.552  11.912   8.793  1.00  0.00           N
ATOM         CA  GLN            12.794  11.266  10.077  1.00  0.00           C
ATOM         C   GLN            11.486  11.088  10.841  1.00  0.00           C
ATOM         O   GLN            11.063   9.965  11.114  1.00  0.00           O
ATOM         CB  GLN            13.778  12.090  10.909  1.00  0.00           C
ATOM         CG  GLN            14.166  11.449  12.233  1.00  0.00           C
ATOM         CD  GLN            15.185  12.267  13.001  1.00  0.00           C
ATOM         OE1 GLN            15.609  13.332  12.552  1.00  0.00           O
ATOM         NE2 GLN            15.585  11.772  14.167  1.00  0.00           N
ATOM         H   GLN            11.841  12.395   8.773  1.00  0.00           H
ATOM         HA  GLN            13.185  10.380   9.926  1.00  0.00           H
ATOM         HB2 GLN            13.376  12.951  11.105  1.00  0.00           H
ATOM         HB3 GLN            14.590  12.218  10.394  1.00  0.00           H
ATOM         HG2 GLN            14.550  10.575  12.061  1.00  0.00           H
ATOM         HG3 GLN            13.376  11.361  12.789  1.00  0.00           H
ATOM        HE21 GLN            15.266  11.024  14.448  1.00  0.00           H
ATOM        HE22 GLN            16.162  12.199  14.640  1.00  0.00           H
TER
END
"""

gln = """
CRYST1   25.084   23.384   24.805  90.00  90.00  90.00 P 1
ATOM         N   GLN            12.552  11.912   8.793  1.00  0.00           N
ATOM         CA  GLN            12.794  11.266  10.077  1.00  0.00           C
ATOM         C   GLN            11.486  11.088  10.841  1.00  0.00           C
ATOM         O   GLN            11.063   9.965  11.114  1.00  0.00           O
ATOM         CB  GLN            13.778  12.090  10.909  1.00  0.00           C
ATOM         CG  GLN            14.166  11.449  12.233  1.00  0.00           C
ATOM         CD  GLN            15.185  12.267  13.001  1.00  0.00           C
ATOM         OE1 GLN            15.609  13.332  12.552  1.00  0.00           O
ATOM         NE2 GLN            15.585  11.772  14.167  1.00  0.00           N
TER
END
"""

glu_h = """
CRYST1   26.121   25.436   23.126  90.00  90.00  90.00 P 1
ATOM      1  N   GLU            14.108  13.722  10.100  1.00  0.00           N
ATOM      2  CA  GLU            13.921  13.963  11.525  1.00  0.00           C
ATOM      3  C   GLU            15.247  14.308  12.194  1.00  0.00           C
ATOM      4  O   GLU            15.377  15.349  12.837  1.00  0.00           O
ATOM      5  CB  GLU            13.304  12.735  12.196  1.00  0.00           C
ATOM      6  CG  GLU            11.939  12.350  11.647  1.00  0.00           C
ATOM      7  CD  GLU            11.354  11.134  12.339  1.00  0.00           C
ATOM      8  OE1 GLU            10.290  10.744  11.992  1.00  0.00           O
ATOM      9  OE2 GLU            12.058  10.554  13.306  1.00  0.00           O
ATOM     10  H   GLU            14.917  13.526   9.882  1.00  0.00           H
ATOM     11  HA  GLU            13.309  14.719  11.647  1.00  0.00           H
ATOM     12  HB2 GLU            13.898  11.979  12.069  1.00  0.00           H
ATOM     13  HB3 GLU            13.201  12.916  13.144  1.00  0.00           H
ATOM     14  HG2 GLU            11.327  13.091  11.773  1.00  0.00           H
ATOM     15  HG3 GLU            12.024  12.145  10.703  1.00  0.00           H
ATOM     16  HE2 GLU            11.561   9.816  13.635  1.00  0.00           H
TER
END
"""

glu = """
CRYST1   26.121   25.436   23.126  90.00  90.00  90.00 P 1
ATOM         N   GLU            14.107  13.721  10.099  1.00  0.00           N
ATOM         CA  GLU            13.923  13.965  11.525  1.00  0.00           C
ATOM         C   GLU            15.250  14.315  12.188  1.00  0.00           C
ATOM         O   GLU            15.375  15.353  12.838  1.00  0.00           O
ATOM         CB  GLU            13.312  12.736  12.200  1.00  0.00           C
ATOM         CG  GLU            11.947  12.345  11.656  1.00  0.00           C
ATOM         CD  GLU            11.368  11.129  12.352  1.00  0.00           C
ATOM         OE1 GLU            10.246  10.714  11.992  1.00  0.00           O
ATOM         OE2 GLU            12.034  10.587  13.260  1.00  0.00           O
TER
END
"""

gly_h = """
CRYST1   22.802   22.387   22.249  90.00  90.00  90.00 P 1
ATOM         N   GLY            10.690  11.634  12.050  1.00  0.00           N
ATOM         CA  GLY             9.834  10.465  12.109  1.00  0.00           C
ATOM         C   GLY             8.514  10.688  11.397  1.00  0.00           C
ATOM         O   GLY             7.548  11.163  11.994  1.00  0.00           O
ATOM         H   GLY            11.449  11.532  12.440  1.00  0.00           H
ATOM         HA2 GLY            10.284   9.712  11.694  1.00  0.00           H
ATOM         HA3 GLY             9.651  10.243  13.035  1.00  0.00           H
TER
END
"""

gly = """
CRYST1   22.802   22.387   22.249  90.00  90.00  90.00 P 1
ATOM         N   GLY            10.690  11.634  12.050  1.00  0.00           N
ATOM         CA  GLY             9.834  10.465  12.109  1.00  0.00           C
ATOM         C   GLY             8.514  10.688  11.397  1.00  0.00           C
ATOM         O   GLY             7.548  11.163  11.994  1.00  0.00           O
TER
END
"""

his_h = """
CRYST1   24.176   25.565   23.504  90.00  90.00  90.00 P 1
ATOM         N   HIS            14.439  12.693  12.792  1.00  0.00           N
ATOM         CA  HIS            13.448  13.609  12.240  1.00  0.00           C
ATOM         C   HIS            13.157  14.742  13.219  1.00  0.00           C
ATOM         O   HIS            13.216  14.556  14.434  1.00  0.00           O
ATOM         CB  HIS            12.156  12.860  11.912  1.00  0.00           C
ATOM         CG  HIS            12.333  11.761  10.911  1.00  0.00           C
ATOM         ND1 HIS            12.206  11.963   9.554  1.00  0.00           N
ATOM         CD2 HIS            12.628  10.449  11.070  1.00  0.00           C
ATOM         CE1 HIS            12.414  10.823   8.920  1.00  0.00           C
ATOM         NE2 HIS            12.672   9.888   9.817  1.00  0.00           N
ATOM         H   HIS            14.112  12.107  13.330  1.00  0.00           H
ATOM         HA  HIS            13.796  14.001  11.412  1.00  0.00           H
ATOM         HB2 HIS            11.513  13.490  11.550  1.00  0.00           H
ATOM         HB3 HIS            11.808  12.466  12.727  1.00  0.00           H
ATOM         HD1 HIS            12.020  12.714   9.178  1.00  0.00           H
ATOM         HD2 HIS            12.773  10.010  11.877  1.00  0.00           H
ATOM         HE1 HIS            12.384  10.699   7.998  1.00  0.00           H
ATOM         HE2 HIS            12.841   9.063   9.644  1.00  0.00           H
TER
END
"""

his = """
CRYST1   24.176   25.565   23.504  90.00  90.00  90.00 P 1
ATOM         N   HIS            14.439  12.693  12.792  1.00  0.00           N
ATOM         CA  HIS            13.448  13.609  12.240  1.00  0.00           C
ATOM         C   HIS            13.157  14.742  13.219  1.00  0.00           C
ATOM         O   HIS            13.216  14.556  14.434  1.00  0.00           O
ATOM         CB  HIS            12.156  12.860  11.912  1.00  0.00           C
ATOM         CG  HIS            12.333  11.761  10.911  1.00  0.00           C
ATOM         ND1 HIS            12.206  11.963   9.554  1.00  0.00           N
ATOM         CD2 HIS            12.628  10.449  11.070  1.00  0.00           C
ATOM         CE1 HIS            12.414  10.823   8.920  1.00  0.00           C
ATOM         NE2 HIS            12.672   9.888   9.817  1.00  0.00           N
TER
END
"""

ile_h = """
CRYST1   25.412   23.292   23.916  90.00  90.00  90.00 P 1
ATOM      1  N   ILE            12.301  11.470  15.047  1.00  0.00           N
ATOM      2  CA  ILE            11.713  11.920  13.792  1.00  0.00           C
ATOM      3  C   ILE            10.597  10.981  13.342  1.00  0.00           C
ATOM      4  O   ILE            10.391   9.920  13.932  1.00  0.00           O
ATOM      5  CB  ILE            12.774  12.021  12.676  1.00  0.00           C
ATOM      6  CG1 ILE            13.536  10.697  12.538  1.00  0.00           C
ATOM      7  CG2 ILE            13.738  13.163  12.972  1.00  0.00           C
ATOM      8  CD1 ILE            14.482  10.647  11.352  1.00  0.00           C
ATOM      9  H   ILE            11.834  10.877  15.460  1.00  0.00           H
ATOM     10  HA  ILE            11.328  12.801  13.921  1.00  0.00           H
ATOM     11  HB  ILE            12.324  12.207  11.837  1.00  0.00           H
ATOM     12 HG12 ILE            14.065  10.555  13.339  1.00  0.00           H
ATOM     13 HG13 ILE            12.901   9.972  12.433  1.00  0.00           H
ATOM     14 HG21 ILE            14.177  13.433  12.150  1.00  0.00           H
ATOM     15 HG22 ILE            13.238  13.910  13.337  1.00  0.00           H
ATOM     16 HG23 ILE            14.396  12.862  13.618  1.00  0.00           H
ATOM     17 HD11 ILE            14.054  11.067  10.589  1.00  0.00           H
ATOM     18 HD12 ILE            15.299  11.120  11.576  1.00  0.00           H
ATOM     19 HD13 ILE            14.684   9.720  11.151  1.00  0.00           H
TER
END
"""

ile = """
CRYST1   25.412   23.292   23.916  90.00  90.00  90.00 P 1
ATOM         N   ILE            12.305  11.475  15.047  1.00  0.00           N
ATOM         CA  ILE            11.714  11.920  13.791  1.00  0.00           C
ATOM         C   ILE            10.602  10.976  13.345  1.00  0.00           C
ATOM         O   ILE            10.397   9.918  13.940  1.00  0.00           O
ATOM         CB  ILE            12.773  12.022  12.675  1.00  0.00           C
ATOM         CG1 ILE            13.530  10.696  12.532  1.00  0.00           C
ATOM         CG2 ILE            13.740  13.159  12.972  1.00  0.00           C
ATOM         CD1 ILE            14.484  10.651  11.353  1.00  0.00           C
TER
END
"""

leu_h = """
CRYST1   23.694   25.206   23.362  90.00  90.00  90.00 P 1
ATOM      1  N   LEU            11.496  10.501  10.237  1.00  0.00           N
ATOM      2  CA  LEU            12.729  11.070  10.767  1.00  0.00           C
ATOM      3  C   LEU            13.677   9.966  11.221  1.00  0.00           C
ATOM      4  O   LEU            13.743   8.900  10.608  1.00  0.00           O
ATOM      5  CB  LEU            12.423  12.006  11.939  1.00  0.00           C
ATOM      6  CG  LEU            11.480  13.181  11.658  1.00  0.00           C
ATOM      7  CD1 LEU            11.040  13.830  12.961  1.00  0.00           C
ATOM      8  CD2 LEU            12.129  14.208  10.739  1.00  0.00           C
ATOM      9  H   LEU            11.216  10.881   9.518  1.00  0.00           H
ATOM     10  HA  LEU            13.172  11.580  10.071  1.00  0.00           H
ATOM     11  HB2 LEU            13.261  12.380  12.253  1.00  0.00           H
ATOM     12  HB3 LEU            12.022  11.481  12.649  1.00  0.00           H
ATOM     13  HG  LEU            10.687  12.845  11.213  1.00  0.00           H
ATOM     14 HD11 LEU            10.578  13.170  13.502  1.00  0.00           H
ATOM     15 HD12 LEU            11.823  14.154  13.432  1.00  0.00           H
ATOM     16 HD13 LEU            10.444  14.569  12.760  1.00  0.00           H
ATOM     17 HD21 LEU            13.010  14.427  11.081  1.00  0.00           H
ATOM     18 HD22 LEU            12.203  13.835   9.847  1.00  0.00           H
ATOM     19 HD23 LEU            11.575  15.004  10.717  1.00  0.00           H
TER
END
"""

leu = """
CRYST1   23.694   25.206   23.362  90.00  90.00  90.00 P 1
ATOM      1  N   LEU            11.498  10.510  10.231  1.00  0.00           N
ATOM      2  CA  LEU            12.730  11.073  10.769  1.00  0.00           C
ATOM      3  C   LEU            13.674   9.966  11.221  1.00  0.00           C
ATOM      4  O   LEU            13.739   8.902  10.605  1.00  0.00           O
ATOM      5  CB  LEU            12.421  12.004  11.944  1.00  0.00           C
ATOM      6  CG  LEU            11.478  13.179  11.661  1.00  0.00           C
ATOM      7  CD1 LEU            11.043  13.834  12.963  1.00  0.00           C
ATOM      8  CD2 LEU            12.126  14.201  10.736  1.00  0.00           C
TER
END
"""

lys_h = """
CRYST1   25.386   27.917   22.984  90.00  90.00  90.00 P 1
ATOM         N   LYS            10.286  15.612  10.841  1.00  0.00           N
ATOM         CA  LYS            11.191  15.832  11.962  1.00  0.00           C
ATOM         C   LYS            11.489  17.317  12.133  1.00  0.00           C
ATOM         O   LYS            10.576  18.133  12.258  1.00  0.00           O
ATOM         CB  LYS            12.495  15.060  11.752  1.00  0.00           C
ATOM         CG  LYS            12.313  13.555  11.639  1.00  0.00           C
ATOM         CD  LYS            13.643  12.847  11.440  1.00  0.00           C
ATOM         CE  LYS            13.461  11.342  11.328  1.00  0.00           C
ATOM         NZ  LYS            14.756  10.635  11.132  1.00  0.00           N
ATOM         H   LYS             9.453  15.663  11.049  1.00  0.00           H
ATOM         HA  LYS            10.771  15.506  12.786  1.00  0.00           H
ATOM         HB2 LYS            12.912  15.370  10.932  1.00  0.00           H
ATOM         HB3 LYS            13.084  15.232  12.503  1.00  0.00           H
ATOM         HG2 LYS            11.909  13.220  12.455  1.00  0.00           H
ATOM         HG3 LYS            11.746  13.357  10.878  1.00  0.00           H
ATOM         HD2 LYS            14.056  13.166  10.622  1.00  0.00           H
ATOM         HD3 LYS            14.219  13.028  12.199  1.00  0.00           H
ATOM         HE2 LYS            13.055  11.009  12.143  1.00  0.00           H
ATOM         HE3 LYS            12.892  11.147  10.567  1.00  0.00           H
ATOM         HZ1 LYS            14.617   9.758  11.070  1.00  0.00           H
ATOM         HZ2 LYS            15.297  10.794  11.821  1.00  0.00           H
ATOM         HZ3 LYS            15.148  10.919  10.385  1.00  0.00           H
TER
END
"""

lys = """
CRYST1   25.386   27.917   22.984  90.00  90.00  90.00 P 1
ATOM         N   LYS            10.286  15.612  10.841  1.00  0.00           N
ATOM         CA  LYS            11.191  15.832  11.962  1.00  0.00           C
ATOM         C   LYS            11.489  17.317  12.133  1.00  0.00           C
ATOM         O   LYS            10.576  18.133  12.258  1.00  0.00           O
ATOM         CB  LYS            12.495  15.060  11.752  1.00  0.00           C
ATOM         CG  LYS            12.313  13.555  11.639  1.00  0.00           C
ATOM         CD  LYS            13.643  12.847  11.440  1.00  0.00           C
ATOM         CE  LYS            13.461  11.342  11.328  1.00  0.00           C
ATOM         NZ  LYS            14.756  10.635  11.132  1.00  0.00           N
TER
END
"""

met_h = """
CRYST1   23.837   23.774   26.142  90.00  90.00  90.00 P 1
ATOM      1  N   MET            12.647  11.204  11.719  1.00  0.00           N
ATOM      2  CA  MET            11.653  12.243  11.957  1.00  0.00           C
ATOM      3  C   MET            11.300  12.955  10.656  1.00  0.00           C
ATOM      4  O   MET            10.126  13.108  10.319  1.00  0.00           O
ATOM      5  CB  MET            12.177  13.255  12.977  1.00  0.00           C
ATOM      6  CG  MET            12.502  12.653  14.335  1.00  0.00           C
ATOM      7  SD  MET            13.776  11.380  14.247  1.00  0.00           S
ATOM      8  CE  MET            13.901  10.907  15.970  1.00  0.00           C
ATOM      9  H   MET            13.335  11.472  11.278  1.00  0.00           H
ATOM     10  HA  MET            10.852  11.836  12.322  1.00  0.00           H
ATOM     11  HB2 MET            12.989  13.656  12.629  1.00  0.00           H
ATOM     12  HB3 MET            11.504  13.940  13.111  1.00  0.00           H
ATOM     13  HG2 MET            12.820  13.355  14.924  1.00  0.00           H
ATOM     14  HG3 MET            11.700  12.250  14.702  1.00  0.00           H
ATOM     15  HE1 MET            13.039  10.578  16.270  1.00  0.00           H
ATOM     16  HE2 MET            14.570  10.211  16.058  1.00  0.00           H
ATOM     17  HE3 MET            14.159  11.683  16.492  1.00  0.00           H
TER
END
"""

met = """
CRYST1   23.837   23.774   26.142  90.00  90.00  90.00 P 1
ATOM         N   MET            12.648  11.204  11.719  1.00  0.00           N
ATOM         CA  MET            11.654  12.243  11.957  1.00  0.00           C
ATOM         C   MET            11.302  12.956  10.656  1.00  0.00           C
ATOM         O   MET            10.128  13.108  10.319  1.00  0.00           O
ATOM         CB  MET            12.178  13.255  12.977  1.00  0.00           C
ATOM         CG  MET            12.502  12.653  14.335  1.00  0.00           C
ATOM         SD  MET            13.776  11.380  14.248  1.00  0.00           S
ATOM         CE  MET            13.901  10.907  15.971  1.00  0.00           C
TER
END
"""

mse_h = """
CRYST1   23.971   24.634   24.903  90.00  90.00  90.00 P 1
ATOM      1  N   MSE            13.013  14.421  10.982  1.00  0.00           N
ATOM      2  CA  MSE            11.597  14.085  10.914  1.00  0.00           C
ATOM      3  C   MSE            10.788  15.272  10.406  1.00  0.00           C
ATOM      4  O   MSE             9.734  15.101   9.793  1.00  0.00           O
ATOM      5  CB  MSE            11.085  13.661  12.292  1.00  0.00           C
ATOM      6  CG  MSE            11.782  12.435  12.861  1.00  0.00           C
ATOM      7  SE  MSE            11.089  11.919  14.609  1.00  0.00          SE
ATOM      8  CE  MSE            12.224  10.368  14.939  1.00  0.00           C
ATOM      9  H   MSE            13.471  14.142  10.309  1.00  0.00           H
ATOM     10  HA  MSE            11.477  13.338  10.307  1.00  0.00           H
ATOM     11  HB2 MSE            10.139  13.459  12.225  1.00  0.00           H
ATOM     12  HB3 MSE            11.221  14.393  12.914  1.00  0.00           H
ATOM     13  HG2 MSE            11.653  11.689  12.255  1.00  0.00           H
ATOM     14  HG3 MSE            12.728  12.625  12.958  1.00  0.00           H
ATOM     15  HE1 MSE            11.994   9.987  15.800  1.00  0.00           H
ATOM     16  HE2 MSE            12.077   9.715  14.237  1.00  0.00           H
ATOM     17  HE3 MSE            13.152  10.651  14.939  1.00  0.00           H
TER
END
"""

mse = """
CRYST1   23.971   24.634   24.903  90.00  90.00  90.00 P 1
ATOM         N   MSE            13.014  14.418  10.984  1.00  0.00           N
ATOM         CA  MSE            11.596  14.085  10.915  1.00  0.00           C
ATOM         C   MSE            10.791  15.276  10.409  1.00  0.00           C
ATOM         O   MSE             9.737  15.108   9.795  1.00  0.00           O
ATOM         CB  MSE            11.084  13.659  12.292  1.00  0.00           C
ATOM         CG  MSE            11.781  12.434  12.861  1.00  0.00           C
ATOM         SE  MSE            11.090  11.919  14.610  1.00  0.00          SE
ATOM         CE  MSE            12.226  10.369  14.939  1.00  0.00           C
TER
END
"""

phe_h = """
CRYST1   23.164   27.189   25.737  90.00  90.00  90.00 P 1
ATOM         N   PHE            12.221  15.187  13.192  1.00  0.00           N
ATOM         CA  PHE            12.405  14.591  11.875  1.00  0.00           C
ATOM         C   PHE            12.185  15.626  10.778  1.00  0.00           C
ATOM         O   PHE            12.417  16.818  10.981  1.00  0.00           O
ATOM         CB  PHE            11.442  13.417  11.683  1.00  0.00           C
ATOM         CG  PHE            11.637  12.305  12.673  1.00  0.00           C
ATOM         CD1 PHE            12.550  11.293  12.427  1.00  0.00           C
ATOM         CD2 PHE            10.906  12.270  13.850  1.00  0.00           C
ATOM         CE1 PHE            12.731  10.267  13.336  1.00  0.00           C
ATOM         CE2 PHE            11.083  11.247  14.763  1.00  0.00           C
ATOM         CZ  PHE            11.997  10.245  14.505  1.00  0.00           C
ATOM         H   PHE            11.602  15.784  13.222  1.00  0.00           H
ATOM         HA  PHE            13.321  14.252  11.799  1.00  0.00           H
ATOM         HB2 PHE            11.571  13.049  10.795  1.00  0.00           H
ATOM         HB3 PHE            10.532  13.741  11.776  1.00  0.00           H
ATOM         HD1 PHE            13.047  11.303  11.642  1.00  0.00           H
ATOM         HD2 PHE            10.289  12.943  14.028  1.00  0.00           H
ATOM         HE1 PHE            13.348   9.593  13.161  1.00  0.00           H
ATOM         HE2 PHE            10.587  11.234  15.549  1.00  0.00           H
ATOM         HZ  PHE            12.118   9.556  15.118  1.00  0.00           H
TER
END
"""

phe = """
CRYST1   23.164   27.189   25.737  90.00  90.00  90.00 P 1
ATOM         N   PHE            12.221  15.187  13.192  1.00  0.00           N
ATOM         CA  PHE            12.405  14.591  11.875  1.00  0.00           C
ATOM         C   PHE            12.185  15.626  10.778  1.00  0.00           C
ATOM         O   PHE            12.417  16.818  10.981  1.00  0.00           O
ATOM         CB  PHE            11.442  13.417  11.683  1.00  0.00           C
ATOM         CG  PHE            11.637  12.305  12.673  1.00  0.00           C
ATOM         CD1 PHE            12.550  11.293  12.427  1.00  0.00           C
ATOM         CD2 PHE            10.906  12.270  13.850  1.00  0.00           C
ATOM         CE1 PHE            12.731  10.267  13.336  1.00  0.00           C
ATOM         CE2 PHE            11.083  11.247  14.763  1.00  0.00           C
ATOM         CZ  PHE            11.997  10.245  14.505  1.00  0.00           C
TER
END
"""

pro_h = """
CRYST1   23.908   24.362   23.218  90.00  90.00  90.00 P 1
ATOM         N   PRO            11.501  12.360  11.686  1.00  0.00           N
ATOM         CA  PRO            12.698  12.017  10.912  1.00  0.00           C
ATOM         C   PRO            13.043  10.534  11.005  1.00  0.00           C
ATOM         O   PRO            13.706  10.018  10.105  1.00  0.00           O
ATOM         CB  PRO            13.791  12.861  11.572  1.00  0.00           C
ATOM         CG  PRO            13.069  14.029  12.142  1.00  0.00           C
ATOM         CD  PRO            11.732  13.508  12.581  1.00  0.00           C
ATOM         HA  PRO            12.595  12.280   9.973  1.00  0.00           H
ATOM         HB2 PRO            14.435  13.146  10.904  1.00  0.00           H
ATOM         HB3 PRO            14.225  12.348  12.272  1.00  0.00           H
ATOM         HG2 PRO            13.564  14.379  12.899  1.00  0.00           H
ATOM         HG3 PRO            12.963  14.710  11.459  1.00  0.00           H
ATOM         HD2 PRO            11.770  13.214  13.505  1.00  0.00           H
ATOM         HD3 PRO            11.047  14.182  12.450  1.00  0.00           H
TER
END
"""

pro = """
CRYST1   23.908   24.362   23.218  90.00  90.00  90.00 P 1
ATOM         N   PRO            11.501  12.360  11.686  1.00  0.00           N
ATOM         CA  PRO            12.698  12.017  10.912  1.00  0.00           C
ATOM         C   PRO            13.043  10.534  11.005  1.00  0.00           C
ATOM         O   PRO            13.706  10.018  10.105  1.00  0.00           O
ATOM         CB  PRO            13.791  12.861  11.572  1.00  0.00           C
ATOM         CG  PRO            13.069  14.029  12.142  1.00  0.00           C
ATOM         CD  PRO            11.732  13.508  12.581  1.00  0.00           C
TER
END
"""

ser_h = """
CRYST1   23.945   22.105   23.439  90.00  90.00  90.00 P 1
ATOM      1  N   SER            11.645  10.954  10.372  1.00  0.00           N
ATOM      2  CA  SER            12.136  10.871  11.742  1.00  0.00           C
ATOM      3  C   SER            12.176  12.252  12.386  1.00  0.00           C
ATOM      4  O   SER            11.136  12.863  12.631  1.00  0.00           O
ATOM      5  CB  SER            13.531  10.243  11.769  1.00  0.00           C
ATOM      6  OG  SER            14.023  10.155  13.095  1.00  0.00           O
ATOM      7  H   SER            12.200  11.315   9.823  1.00  0.00           H
ATOM      8  HA  SER            11.540  10.310  12.262  1.00  0.00           H
ATOM      9  HB2 SER            14.134  10.793  11.245  1.00  0.00           H
ATOM     10  HB3 SER            13.482   9.351  11.391  1.00  0.00           H
ATOM     11  HG  SER            14.798   9.805  13.094  1.00  0.00           H
TER
END
"""

ser = """
CRYST1   23.945   22.105   23.439  90.00  90.00  90.00 P 1
ATOM         N   SER            11.646  10.954  10.373  1.00  0.00           N
ATOM         CA  SER            12.139  10.870  11.742  1.00  0.00           C
ATOM         C   SER            12.179  12.251  12.387  1.00  0.00           C
ATOM         O   SER            11.140  12.863  12.631  1.00  0.00           O
ATOM         CB  SER            13.534  10.243  11.768  1.00  0.00           C
ATOM         OG  SER            14.028  10.153  13.093  1.00  0.00           O
TER
END
"""

thr_h = """
CRYST1   23.537   23.329   24.585  90.00  90.00  90.00 P 1
ATOM      1  N   THR            12.700  11.982  12.397  1.00  0.00           N
ATOM      2  CA  THR            11.257  11.774  12.395  1.00  0.00           C
ATOM      3  C   THR            10.829  10.943  13.599  1.00  0.00           C
ATOM      4  O   THR            11.667  10.431  14.341  1.00  0.00           O
ATOM      5  CB  THR            10.795  11.061  11.110  1.00  0.00           C
ATOM      6  OG1 THR            11.442   9.787  11.006  1.00  0.00           O
ATOM      7  CG2 THR            11.126  11.899   9.883  1.00  0.00           C
ATOM      8  H   THR            12.938  12.781  12.608  1.00  0.00           H
ATOM      9  HA  THR            10.810  12.633  12.443  1.00  0.00           H
ATOM     10  HB  THR             9.834  10.932  11.142  1.00  0.00           H
ATOM     11  HG1 THR            11.190   9.389  10.298  1.00  0.00           H
ATOM     12 HG21 THR            12.087  11.998   9.797  1.00  0.00           H
ATOM     13 HG22 THR            10.781  11.467   9.086  1.00  0.00           H
ATOM     14 HG23 THR            10.723  12.778   9.964  1.00  0.00           H
TER
END
"""

thr = """
CRYST1   23.537   23.329   24.585  90.00  90.00  90.00 P 1
ATOM         N   THR            12.700  11.978  12.392  1.00  0.00           N
ATOM         CA  THR            11.258  11.770  12.392  1.00  0.00           C
ATOM         C   THR            10.832  10.937  13.596  1.00  0.00           C
ATOM         O   THR            11.672  10.431  14.341  1.00  0.00           O
ATOM         CB  THR            10.793  11.061  11.107  1.00  0.00           C
ATOM         OG1 THR            11.436   9.785  11.001  1.00  0.00           O
ATOM         CG2 THR            11.126  11.899   9.881  1.00  0.00           C
TER
END
"""

trp_h = """
CRYST1   24.225   23.655   29.176  90.00  90.00  90.00 P 1
ATOM         N   TRP            12.996  11.322  12.366  1.00  0.00           N
ATOM         CA  TRP            11.680  10.883  12.812  1.00  0.00           C
ATOM         C   TRP            10.782  10.571  11.620  1.00  0.00           C
ATOM         O   TRP            10.933  11.155  10.547  1.00  0.00           O
ATOM         CB  TRP            11.029  11.956  13.687  1.00  0.00           C
ATOM         CG  TRP            11.819  12.285  14.916  1.00  0.00           C
ATOM         CD1 TRP            12.786  13.240  15.039  1.00  0.00           C
ATOM         CD2 TRP            11.709  11.659  16.201  1.00  0.00           C
ATOM         NE1 TRP            13.285  13.247  16.319  1.00  0.00           N
ATOM         CE2 TRP            12.640  12.286  17.052  1.00  0.00           C
ATOM         CE3 TRP            10.913  10.629  16.713  1.00  0.00           C
ATOM         CZ2 TRP            12.798  11.918  18.386  1.00  0.00           C
ATOM         CZ3 TRP            11.071  10.265  18.038  1.00  0.00           C
ATOM         CH2 TRP            12.006  10.908  18.860  1.00  0.00           C
ATOM         H   TRP            12.975  11.969  11.799  1.00  0.00           H
ATOM         HA  TRP            11.775  10.067  13.347  1.00  0.00           H
ATOM         HB2 TRP            10.936  12.769  13.167  1.00  0.00           H
ATOM         HB3 TRP            10.156  11.643  13.969  1.00  0.00           H
ATOM         HD1 TRP            13.066  13.803  14.354  1.00  0.00           H
ATOM         HE1 TRP            13.901  13.770  16.612  1.00  0.00           H
ATOM         HE3 TRP            10.290  10.198  16.174  1.00  0.00           H
ATOM         HZ2 TRP            13.418  12.342  18.935  1.00  0.00           H
ATOM         HZ3 TRP            10.548   9.582  18.390  1.00  0.00           H
ATOM         HH2 TRP            12.091  10.642  19.747  1.00  0.00           H
TER
END
"""

trp = """
CRYST1   24.225   23.655   29.176  90.00  90.00  90.00 P 1
ATOM         N   TRP            12.996  11.322  12.366  1.00  0.00           N
ATOM         CA  TRP            11.680  10.883  12.812  1.00  0.00           C
ATOM         C   TRP            10.782  10.571  11.620  1.00  0.00           C
ATOM         O   TRP            10.933  11.155  10.547  1.00  0.00           O
ATOM         CB  TRP            11.029  11.956  13.687  1.00  0.00           C
ATOM         CG  TRP            11.819  12.285  14.916  1.00  0.00           C
ATOM         CD1 TRP            12.786  13.240  15.039  1.00  0.00           C
ATOM         CD2 TRP            11.709  11.659  16.201  1.00  0.00           C
ATOM         NE1 TRP            13.285  13.247  16.319  1.00  0.00           N
ATOM         CE2 TRP            12.640  12.286  17.052  1.00  0.00           C
ATOM         CE3 TRP            10.913  10.629  16.713  1.00  0.00           C
ATOM         CZ2 TRP            12.798  11.918  18.386  1.00  0.00           C
ATOM         CZ3 TRP            11.071  10.265  18.038  1.00  0.00           C
ATOM         CH2 TRP            12.006  10.908  18.860  1.00  0.00           C
TER
END
"""

tyr_h = """
CRYST1   27.233   25.082   24.186  90.00  90.00  90.00 P 1
ATOM      1  N   TYR            14.138  13.819  10.940  1.00  0.00           N
ATOM      2  CA  TYR            14.744  13.436  12.209  1.00  0.00           C
ATOM      3  C   TYR            16.254  13.645  12.170  1.00  0.00           C
ATOM      4  O   TYR            16.844  14.156  13.121  1.00  0.00           O
ATOM      5  CB  TYR            14.430  11.973  12.529  1.00  0.00           C
ATOM      6  CG  TYR            12.953  11.681  12.666  1.00  0.00           C
ATOM      7  CD1 TYR            12.205  11.253  11.576  1.00  0.00           C
ATOM      8  CD2 TYR            12.305  11.832  13.886  1.00  0.00           C
ATOM      9  CE1 TYR            10.855  10.985  11.697  1.00  0.00           C
ATOM     10  CE2 TYR            10.955  11.566  14.016  1.00  0.00           C
ATOM     11  CZ  TYR            10.235  11.143  12.919  1.00  0.00           C
ATOM     12  OH  TYR             8.891  10.877  13.043  1.00  0.00           O
ATOM     13  H   TYR            14.536  13.495  10.250  1.00  0.00           H
ATOM     14  HA  TYR            14.379  13.988  12.918  1.00  0.00           H
ATOM     15  HB2 TYR            14.857  11.739  13.368  1.00  0.00           H
ATOM     16  HB3 TYR            14.778  11.416  11.816  1.00  0.00           H
ATOM     17  HD1 TYR            12.621  11.146  10.751  1.00  0.00           H
ATOM     18  HD2 TYR            12.788  12.117  14.627  1.00  0.00           H
ATOM     19  HE1 TYR            10.367  10.699  10.958  1.00  0.00           H
ATOM     20  HE2 TYR            10.535  11.672  14.839  1.00  0.00           H
ATOM     21  HH  TYR             8.640  11.015  13.844  1.00  0.00           H
TER
END
"""

tyr = """
CRYST1   27.233   25.082   24.186  90.00  90.00  90.00 P 1
ATOM         N   TYR            14.079  13.838  10.958  1.00  0.00           N
ATOM         CA  TYR            14.720  13.450  12.208  1.00  0.00           C
ATOM         C   TYR            16.225  13.686  12.139  1.00  0.00           C
ATOM         O   TYR            16.836  14.146  13.104  1.00  0.00           O
ATOM         CB  TYR            14.438  11.978  12.517  1.00  0.00           C
ATOM         CG  TYR            12.969  11.659  12.682  1.00  0.00           C
ATOM         CD1 TYR            12.205  11.232  11.603  1.00  0.00           C
ATOM         CD2 TYR            12.346  11.784  13.917  1.00  0.00           C
ATOM         CE1 TYR            10.862  10.939  11.749  1.00  0.00           C
ATOM         CE2 TYR            11.003  11.493  14.073  1.00  0.00           C
ATOM         CZ  TYR            10.267  11.071  12.986  1.00  0.00           C
ATOM         OH  TYR             8.930  10.780  13.137  1.00  0.00           O
TER
END
"""

val_h = """
CRYST1   24.395   22.670   24.718  90.00  90.00  90.00 P 1
ATOM      1  N   VAL            11.958  11.269  13.943  1.00  0.00           N
ATOM      2  CA  VAL            13.188  11.812  13.380  1.00  0.00           C
ATOM      3  C   VAL            13.588  13.090  14.110  1.00  0.00           C
ATOM      4  O   VAL            12.790  14.017  14.240  1.00  0.00           O
ATOM      5  CB  VAL            13.031  12.122  11.878  1.00  0.00           C
ATOM      6  CG1 VAL            14.350  12.614  11.294  1.00  0.00           C
ATOM      7  CG2 VAL            12.532  10.893  11.129  1.00  0.00           C
ATOM      8  H   VAL            12.071  10.552  14.404  1.00  0.00           H
ATOM      9  HA  VAL            13.902  11.164  13.485  1.00  0.00           H
ATOM     10  HB  VAL            12.374  12.827  11.769  1.00  0.00           H
ATOM     11 HG11 VAL            14.504  12.169  10.446  1.00  0.00           H
ATOM     12 HG12 VAL            15.070  12.407  11.909  1.00  0.00           H
ATOM     13 HG13 VAL            14.295  13.573  11.156  1.00  0.00           H
ATOM     14 HG21 VAL            13.125  10.148  11.316  1.00  0.00           H
ATOM     15 HG22 VAL            12.528  11.083  10.178  1.00  0.00           H
ATOM     16 HG23 VAL            11.633  10.683  11.426  1.00  0.00           H
TER
END
"""

val = """
CRYST1   24.395   22.670   24.718  90.00  90.00  90.00 P 1
ATOM      1  N   VAL            11.961  11.261  13.940  1.00  0.00           N
ATOM      2  CA  VAL            13.189  11.810  13.379  1.00  0.00           C
ATOM      3  C   VAL            13.585  13.088  14.112  1.00  0.00           C
ATOM      4  O   VAL            12.786  14.015  14.238  1.00  0.00           O
ATOM      5  CB  VAL            13.032  12.123  11.879  1.00  0.00           C
ATOM      6  CG1 VAL            14.351  12.612  11.293  1.00  0.00           C
ATOM      7  CG2 VAL            12.529  10.897  11.128  1.00  0.00           C
TER
END
"""

unk_h = """
CRYST1   15.213   13.678   12.589  90.00  90.00  90.00 P 1
ATOM      1  N   UNK A   1       8.417   8.260   6.453  1.00 20.00      A    N
ATOM      2  CA  UNK A   1       8.302   6.819   6.641  1.00 20.00      A    C
ATOM      3  C   UNK A   1       9.535   6.113   6.088  1.00 20.00      A    C
ATOM      4  O   UNK A   1       9.858   5.000   6.504  1.00 20.00      A    O
ATOM      5  CB  UNK A   1       7.045   6.291   5.950  1.00 20.00      A    C
ATOM      6  CG  UNK A   1       5.756   6.902   6.474  1.00 20.00      A    C
ATOM      7  OXT UNK A   1      10.213   6.660   5.218  1.00 20.00      A    O-1
ATOM      8  H   UNK A   1       7.976   8.561   5.778  1.00 20.00      A    H
ATOM     10  HA  UNK A   1       8.236   6.623   7.589  1.00 20.00      A    H
ATOM     11  HB1 UNK A   1       7.112   6.478   5.000  1.00 20.00      A    H
ATOM     12  HB2 UNK A   1       7.004   5.329   6.074  1.00 20.00      A    H
ATOM     13  HG1 UNK A   1       5.000   6.517   6.003  1.00 20.00      A    H
ATOM     14  HG2 UNK A   1       5.673   6.717   7.423  1.00 20.00      A    H
ATOM     15  HG3 UNK A   1       5.771   7.861   6.332  1.00 20.00      A    H
"""
#ATOM      9  H2  UNK A   1       8.151   8.678   7.192  1.00 20.00      A    H

unk = """
CRYST1   15.213   13.678   12.589  90.00  90.00  90.00 P 1
ATOM      1  N   UNK A   1       8.417   8.260   6.453  1.00 20.00      A    N
ATOM      2  CA  UNK A   1       8.302   6.819   6.641  1.00 20.00      A    C
ATOM      3  C   UNK A   1       9.535   6.113   6.088  1.00 20.00      A    C
ATOM      4  O   UNK A   1       9.858   5.000   6.504  1.00 20.00      A    O
ATOM      5  CB  UNK A   1       7.045   6.291   5.950  1.00 20.00      A    C
ATOM      6  CG  UNK A   1       5.756   6.902   6.474  1.00 20.00      A    C
ATOM      7  OXT UNK A   1      10.213   6.660   5.218  1.00 20.00      A    O-1
"""

sec_h = '''
CRYST1   14.413   13.247   13.703  90.00  90.00  90.00 P 1
ATOM      1  N   SEC A   1       5.325   7.374   5.793  1.00 20.00      A    N
ATOM      2  CA  SEC A   1       6.781   7.356   5.843  1.00 20.00      A    C
ATOM      3  C   SEC A   1       7.326   6.134   5.114  1.00 20.00      A    C
ATOM      4  O   SEC A   1       6.958   5.000   5.422  1.00 20.00      A    O
ATOM      5  CB  SEC A   1       7.262   7.371   7.286  1.00 20.00      A    C
ATOM      6 SE   SEC A   1       9.115   6.677   7.432  1.00 20.00      A   Se
ATOM      7  H   SEC A   1       5.000   7.509   5.000  1.00 20.00      A    H
ATOM      9  HA  SEC A   1       7.108   8.130   5.423  1.00 20.00      A    H
ATOM     10  HB2 SEC A   1       6.720   6.820   7.820  1.00 20.00      A    H
ATOM     11  HB3 SEC A   1       7.248   8.247   7.624  1.00 20.00      A    H
ATOM     12  HE  SEC A   1       9.413   7.295   8.703  1.00 20.00      A    H
'''
#ATOM      8  H2  SEC A   1       5.092   8.078   6.245  1.00 20.00      A    H

sec = '''
CRYST1   14.413   13.247   13.703  90.00  90.00  90.00 P 1
ATOM      1  N   SEC A   1       5.325   7.374   5.793  1.00 20.00      A    N
ATOM      2  CA  SEC A   1       6.781   7.356   5.843  1.00 20.00      A    C
ATOM      3  C   SEC A   1       7.326   6.134   5.114  1.00 20.00      A    C
ATOM      4  O   SEC A   1       6.958   5.000   5.422  1.00 20.00      A    O
ATOM      5  CB  SEC A   1       7.262   7.371   7.286  1.00 20.00      A    C
ATOM      6 SE   SEC A   1       9.115   6.677   7.432  1.00 20.00      A   Se
'''

pyl_h = '''
CRYST1   17.576   16.310   22.096  90.00  90.00  90.00 P 1
ATOM      1  N   PYL A   1      12.160   9.689   6.621  1.00 20.00      A    N
ATOM      2  CA  PYL A   1      10.780   9.317   6.332  1.00 20.00      A    C
ATOM      3  C   PYL A   1      10.215  10.184   5.213  1.00 20.00      A    C
ATOM      4  O   PYL A   1      10.665  11.310   5.000  1.00 20.00      A    O
ATOM      5  CB  PYL A   1       9.925   9.443   7.584  1.00 20.00      A    C
ATOM      6  CB2 PYL A   1       5.397   6.017  14.824  1.00 20.00      A    C
ATOM      7  CG  PYL A   1      10.064   8.268   8.550  1.00 20.00      A    C
ATOM      8  CG2 PYL A   1       6.915   5.874  14.825  1.00 20.00      A    C
ATOM      9  CD  PYL A   1       9.245   8.452   9.829  1.00 20.00      A    C
ATOM     10  CD2 PYL A   1       7.555   5.757  16.221  1.00 20.00      A    C
ATOM     11  CE  PYL A   1       9.375   7.279  10.794  1.00 20.00      A    C
ATOM     12  CE2 PYL A   1       8.342   7.039  16.315  1.00 20.00      A    C
ATOM     13  NZ  PYL A   1       8.584   7.519  11.993  1.00 20.00      A    N
ATOM     14  C2  PYL A   1       8.548   6.671  13.020  1.00 20.00      A    C
ATOM     15  CA2 PYL A   1       7.668   7.073  14.199  1.00 20.00      A    C
ATOM     16  N2  PYL A   1       8.406   7.731  15.274  1.00 20.00      A    N
ATOM     17  O2  PYL A   1       9.157   5.629  13.065  1.00 20.00      A    O
ATOM     18  H   PYL A   1      12.576  10.034   5.952  1.00 20.00      A    H
ATOM     20  HA  PYL A   1      10.759   8.389   6.051  1.00 20.00      A    H
ATOM     21  HA2 PYL A   1       7.039   7.718  13.840  1.00 20.00      A    H
ATOM     22 HB12 PYL A   1       5.037   5.890  13.932  1.00 20.00      A    H
ATOM     23  HB2 PYL A   1      10.175  10.262   8.040  1.00 20.00      A    H
ATOM     24 HB22 PYL A   1       5.000   5.356  15.413  1.00 20.00      A    H
ATOM     25  HB3 PYL A   1       9.002   9.545   7.305  1.00 20.00      A    H
ATOM     26 HB32 PYL A   1       5.132   6.899  15.128  1.00 20.00      A    H
ATOM     27  HG2 PYL A   1       9.780   7.454   8.106  1.00 20.00      A    H
ATOM     28 HG22 PYL A   1       7.146   5.082  14.314  1.00 20.00      A    H
ATOM     29  HG3 PYL A   1      11.001   8.153   8.772  1.00 20.00      A    H
ATOM     30  HD2 PYL A   1       9.529   9.263  10.279  1.00 20.00      A    H
ATOM     31 HD22 PYL A   1       6.909   5.665  16.939  1.00 20.00      A    H
ATOM     32  HD3 PYL A   1       8.309   8.574   9.603  1.00 20.00      A    H
ATOM     33 HD32 PYL A   1       8.159   5.000  16.284  1.00 20.00      A    H
ATOM     34  HE2 PYL A   1      10.302   7.145  11.044  1.00 20.00      A    H
ATOM     35 HE22 PYL A   1       8.761   7.319  17.096  1.00 20.00      A    H
ATOM     36  HE3 PYL A   1       9.075   6.458  10.373  1.00 20.00      A    H
ATOM     37  HZ  PYL A   1       8.115   8.238  12.051  1.00 20.00      A    H
'''
#ATOM     19  H2  PYL A   1      12.574   8.911   6.743  1.00 20.00      A    H

pyl = '''
CRYST1   17.576   16.310   22.096  90.00  90.00  90.00 P 1
ATOM      1  N   PYL A   1      12.160   9.689   6.621  1.00 20.00      A    N
ATOM      2  CA  PYL A   1      10.780   9.317   6.332  1.00 20.00      A    C
ATOM      3  C   PYL A   1      10.215  10.184   5.213  1.00 20.00      A    C
ATOM      4  O   PYL A   1      10.665  11.310   5.000  1.00 20.00      A    O
ATOM      5  CB  PYL A   1       9.925   9.443   7.584  1.00 20.00      A    C
ATOM      6  CB2 PYL A   1       5.397   6.017  14.824  1.00 20.00      A    C
ATOM      7  CG  PYL A   1      10.064   8.268   8.550  1.00 20.00      A    C
ATOM      8  CG2 PYL A   1       6.915   5.874  14.825  1.00 20.00      A    C
ATOM      9  CD  PYL A   1       9.245   8.452   9.829  1.00 20.00      A    C
ATOM     10  CD2 PYL A   1       7.555   5.757  16.221  1.00 20.00      A    C
ATOM     11  CE  PYL A   1       9.375   7.279  10.794  1.00 20.00      A    C
ATOM     12  CE2 PYL A   1       8.342   7.039  16.315  1.00 20.00      A    C
ATOM     13  NZ  PYL A   1       8.584   7.519  11.993  1.00 20.00      A    N
ATOM     14  C2  PYL A   1       8.548   6.671  13.020  1.00 20.00      A    C
ATOM     15  CA2 PYL A   1       7.668   7.073  14.199  1.00 20.00      A    C
ATOM     16  N2  PYL A   1       8.406   7.731  15.274  1.00 20.00      A    N
ATOM     17  O2  PYL A   1       9.157   5.629  13.065  1.00 20.00      A    O
'''

def residue_dict():
  from mmtbx.monomer_library import idealized_aa as iaa
  aac = iotbx.pdb.amino_acid_codes.one_letter_given_three_letter
  result = {}
  for aa_name in aac.keys():
    aanl = aa_name.lower()
    aanlh= aanl+"_h"
    for aanl_ in [aanl, aanlh]:
      pdb_inp = iotbx.pdb.input(source_info=None, lines=iaa.__dict__[aanl_])
      h = pdb_inp.construct_hierarchy()
      h.atoms().reset_i_seq()
      result.setdefault(aanl_, h)
  return result
