CHANGELOG for 7.3.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 7.3 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v7.3.0...v7.3.1

* 7.3.9 (2025-12-31)

 * bug #62873 [Cache] Fix namespace of chained pools when using another chain as template (nicolas-grekas)
 * bug #62840 [Cache] Fix stampede protection when forcing item recomputation (nicolas-grekas)
 * bug #62845 [HttpClient] Fix ever growing `$maxHostConnections` (nicolas-grekas)
 * bug #62843 [DependencyInjection] Fix referencing build-time array parameters (nicolas-grekas)
 * bug #62841 [Form] Always normalize CRLF and CR to LF in `TextareaType` (alexandre-daubois)
 * bug #62490 [FrameworkBundle] Fix cache:pool:prune exit code on failure (yoeunes)
 * bug #62813 [Console] Fix EofShortcut instruction when using a modern terminal on Windows (fperxas)
 * bug #62827 [Console] Fix choice autocomplete issue when string has spaces (ayyoub-afwallah)
 * bug #62826 [Security] Fix persisting valid origin for both safe and non-safe requests (llegaz)
 * bug #62797 [Serializer] Fix inconsistent field naming from accessors when using groups (nicolas-grekas)
 * bug #62741 [Finder] Fix converting unanchored glob patterns to regex (nicolas-grekas)
 * bug #62759 [Form] do not use PHPUnit mock objects without configured expectations (xabbuh)
 * bug #62796 [Security] do not use PHPUnit mock objects without configured expectations (xabbuh)
 * bug #62808 [Translation] do not use PHPUnit mock objects without configured expectations (xabbuh)
 * bug #62775 [Process] Fix dealing with broken stdin pipes (nicolas-grekas)
 * bug #62791 [Routing] Fix simple parameter mappings in routes (nicolas-grekas)
 * bug #62793 [Cache] Fix calling the callback wrapper for `ChainAdapter` (nicolas-grekas)
 * bug #62799 [Cache][HttpFoundation] Fix VARBINARY columns on sqlsrv (nicolas-grekas)
 * bug #62803 [AssetMapper] Batch concurrent requests to prevent flooding jsdelivr (nicolas-grekas)
 * bug #62810 [TwigBundle] Align TemplateIterator handling of @! original bundle templates with TwigExtension (mbessolov)
 * bug #62812 [Messenger][AMQP] Fix negative delays with AMQP messenger transport (hockdudu)
 * bug #62794 [JsonPath] fix calling non-static method statically (keradus)
 * bug #62772 [PropertyInfo] Fix calling same-named method with required args instead of reading public property (makraz)
 * bug #62773 [Serializer] Do not skip nested `null` values when denormalizing (MatTheCat)
 * bug #62745 [Validator] do not use PHPUnit mock objects without configured expectations (xabbuh)
 * bug #62755 [DependencyInjection] Fix `#[AutowireCallable]` sometimes incorrectly inlined (HypeMC)
 * bug #61963 [Doctrine][Messenger] Remove old MySQL special handling that causes deadlocks (psihius)
 * bug #62744 [TwigBridge] do not use PHPUnit mock objects without configured expectations (xabbuh)
 * bug #62756 [Mailer] do not use PHPUnit mock objects without configured expectations (xabbuh)
 * bug #62740 [Serializer] Fix php 8.5 warning unexpected NAN value was coerced to … (aaa2000)
 * bug #62758 [BrowserKit] Allow Cookie expiration to be an int (derrabus)
 * bug #62764 [Console] Escape `` in description of console commands (SiebeVE)
 * bug #62396 [PropertyInfo] Fix inconsistency between isWritable and getWriteInfo (yoeunes)
 * bug #62699 [HttpClient] Fix `ScopingHttpClient` to always pass `base_uri` as `string` instead of parsed `array` (santysisi)
 * bug #62717 [PropertyInfo] fix ``@var`` tag support for `PhpStanExtractor` (qconer)
 * bug #62706 [HttpClient] Fix PHP deprecation when using `AmpHttpClient` (nicolas-grekas)
 * bug #62698 [HttpClient] Fix copy as curl for arrays with resources & unreachable host (HypeMC)
 * bug #62691 [JsonPath] Update and fix the compliance test suite (alexandre-daubois)
 * bug #62686 [PropertyInfo] Fix PseudoType support in PhpDocTypeHelper (VincentLanglet)
 * bug #62715 [DependencyInjection] Fix sharing services used only by tagged iterators (nicolas-grekas)
 * bug #62714 [DependencyInjection] Handle recursive factory reentry for shared services in `PhpDumper` (nicolas-grekas)
 * bug #62685 [DependencyInjection] Fix `PriorityTaggedServiceTrait` when tag attributes are not a list (GromNaN)

* 7.3.8 (2025-12-07)

 * bug #62675 [DependencyInjection] Fix dealing with errored service definitions (nicolas-grekas)
 * bug #62488 [HttpKernel] Make `#[Cache]` respect all explicit cache directives set in controller (ayyoub-afwallah)
 * bug #62665 [DependencyInjection] Revert "bug #62541  Reset resolved state when setting a parameter" (nicolas-grekas)
 * bug #62388 [TypeInfo] Simple array should be array type (matijn-made)
 * bug #61962  [Console] Handle signals on text input (valx76)
 * bug #62661 [Runtime] Reuse the already created Request object when the app needs one as argument and returns a kernel (nicolas-grekas)
 * bug #62621 [Form] Fix moneytype step (Belhassen)
 * bug #62627 [Console] Preserve `--help` option when a command is not found (santysisi)
 * bug #62619 [Messenger] Fix PHP 8.5 deprecation for pgsqlGetNotify() in PostgreSQL transport (Shine-neko)
 * bug #62612 [Yaml] Fix regression handling blank lines in unquoted scalars (yoeunes)
 * bug #62645 [HttpClient] Fix sharing CurlClientState between clones of CurlHttpClient instances (nicolas-grekas)
 * bug #62541 [DependencyInjection] Reset resolved state when setting a parameter (yoeunes)
 * bug #62602 [Cache] Fix the creation of a redis connection with only ext-relay (stof)
 * bug #62587 [PropertyInfo] treat mixed[] the same as array when getting types from docblocks (xabbuh)
 * bug #62524 [Notifier][Mercure] Add support for Mercure 0.7 (Kocal)
 * bug #62577 [PropertyInfo] treat `mixed[]` the same as `array` when getting types from docblocks (xabbuh)
 * bug #62498 [FrameworkBundle] fix merging of enabled locales (dmaicher)
 * bug #62551 [FrameworkBundle] register attribute loader arguments in a forward-compatible way (xabbuh)
 * bug #62465  [JsonPath] Fix throwing on quoted True/False/Null (TamasSzigeti)
 * bug #62482 [DependencyInjection] Fix loose validation in `#[Autowire]` attribute (yoeunes)
 * bug #62513 [FrameworkBundle] Add missing `useAttributeAsKey` calls (MatTheCat)
 * bug #62523 [DependencyInjection] Fix state corruption in `PhpFileLoader` during recursive imports (yoeunes)
 * bug #62543 [Cache] ensure compatibility with RelayCluster 0.20.0 (xabbuh)
 * bug #62536 [Cache] ensure compatibility with Relay extension 0.20.0 (xabbuh)
 * bug #62506 [DependencyInjection] Fix `query_string` env processor for URLs without query string (yoeunes)
 * bug #62502 [HttpFoundation] Fix Expires response header for EventStream (4513)
 * bug #62503 [HttpClient] Fix releasing uploaded stream resources (nicolas-grekas)
 * bug #62474 [Config] Fix nullable EnumNode with BackedEnum (yoeunes)
 * bug #62485 [DependencyInjection] Fix loop corruption in `CheckTypeDeclarationsPass` (yoeunes)
 * bug #62486 [DependencyInjection] Fix invalid PHP syntax for nullable `TypedReference` in `PhpDumper` (yoeunes)
 * bug #62487 [Security] Fix `UserBadge` validation bypass via identifier normalizer (yoeunes)
 * bug #62489 [FrameworkBundle] Fix TypeError when traversing scalar values in debug:config (yoeunes)
 * bug #62493 [Console] Fix exception message when abbreviation matches multiple hidden commands (yoeunes)
 * bug #62471 [String] Fix normalization in trimPrefix/trimSuffix (yoeunes)
 * bug #62456 [AssetMapper] Fix entrypoint status lost during update (yoeunes)
 * bug #62416 [Console] Fix completion for global options values (HypeMC)
 * bug #62458 [Workflow] Fix `MethodMarkingStore` crash with inherited uninitialized properties (yoeunes)
 * bug #62459 [Routing] Fix case sensitivity for static host matching in compiled routes (yoeunes)
 * bug #62461 [Routing] Fix localized prefix updates breaking aliases (yoeunes)
 * bug #62460 [Routing] Fix addNamePrefix breaking aliases to external routes (yoeunes)
 * bug #62449 [HttpKernel] Fix using MapRequestPayload on nullable arguments (nicolas-grekas)
 * bug #62415 [HttpClient] Don't reset unused clients in data collector (HypeMC)
 * bug #62437 [DependencyInjection] Fix preloading `LazyClosure` (nicolas-grekas)
 * bug #62409 [Yaml] Align unquoted multiline scalar parsing with spec for comments (yoeunes)
 * bug #62398 [Cache] Fix accepting named closures as early-expiration callbacks (nicolas-grekas)
 * bug #62406 [Notifier] do not use recipient phone numbers as sender e-mail addresses (xabbuh)
 * bug #62407 [FrameworkBundle] work around limitation in `JsonResponse` when the data is `null` (xabbuh)
 * bug #62400 [Form] Fix EnumType choice_label logic for grouped choices (yoeunes)
 * bug #62393 [Dependencyinjection] Call default index method when index is not provided by tag (yoeunes)
 * bug #62372 [Cache] Recognize saveDeferred events as writes in `CacheDataCollector` (yitznewton)
 * bug #62335 [Console] Fix signal handlers not being cleared after command termination (yoeunes)
 * bug #62348 [Translation][Lokalise] fix "Project too big for sync export" (santysisi)
 * bug #62304 [DependencyInjection] Fix lazy proxy creation for interfaces aliased to final classes (yoeunes)
 * bug #62036 [HttpKernel] Fix StreamedResponse with chunks support in HttpKernelBrowser (wuchen90)
 * bug #62063 [JsonStreamer] Rebuild cache on class update (mtarld)
 * bug #62287 [HttpFoundation] Fix AcceptHeader overwrites items with different parameters (yoeunes)
 * bug #62325 [Routing] Fix default value not taken if usigng name:entity.attribute (eltharin)
 * bug #62329 [DependencyInjection] Fix merging explicit tags and #[AsTaggeditem] (nicolas-grekas)
 * bug #62356 [HttpClient] Fix `Warning: curl_multi_select(): timeout must be positive` (Jeroeny)
 * bug #62334 [PropertyInfo] Fix `ReflectionExtractor` handling of underscore-only property names (yoeunes)
 * bug #58473 [Serializer] Fix `AbstractObjectNormalizer` to allow scalar values to be normalized (Hanmac, xabbuh)
 * bug #62093 [Security] Fix `HttpUtils::createRequest()` when the context’s base URL isn’t empty (MatTheCat)
 * bug #62007 [Serializer] fix inherited properties normalization (Link1515)
 * bug #62286 [Cache] compatibility with ext-redis 6.3 (xabbuh)
 * bug #62321 [Serializer] Fix BackedEnumNormalizer behavior with partial denormalization (yoeunes)
 * bug #62344 [OptionsResolver] Fix missing prototype key in nested error paths (yoeunes)
 * bug #62346 [Clock] Align MockClock::sleep() behavior with NativeClock for negative values (yoeunes)
 * bug #62347 [OptionsResolver] Ensure remove() also unsets deprecation status (yoeunes)
 * bug #62359 [Yaml] Fix parsing of unquoted multiline scalars with comments or blank lines (yoeunes)
 * bug #62350 [ExpressionLanguage] Compile numbers with var_export in Compiler::repr for thread-safety (yoeunes)

* 7.3.7 (2025-11-12)

 * security #cve-2025-64500 [HttpFoundation] Fix parsing pathinfo with no leading slash (nicolas-grekas)
 * bug #62333  Postal mailer transport message ID retrieval (lalcebo)

* 7.3.6 (2025-11-06)

 * bug #62324 [HttpFoundation] Fix parsing hosts and schemes in URLs (nicolas-grekas)
 * bug #62171 [Messenger] Fix commands writing to `STDERR` instead of `STDOUT` (wazum)
 * bug #62315  Keep body size limit for AMP redirects (villermen)
 * bug #62237 [Form] Fix EnumType choice_label logic for grouped choices (yoeunes)
 * bug #62283 [Filesystem] Unify logic for isAbsolute() in Path (yoeunes)
 * bug #62091 [BrowserKit] The BrowserKit history with parameter separator without slash. (biozshock)
 * bug #62297 [Twig] Ensure WrappedTemplatedEmail::getReturnPath() returns a string (yoeunes)
 * bug #62294 [Console] Add missing VERBOSITY_SILENT case in CommandDataCollector (yoeunes)
 * bug #62290 [Routing] Fix matching the "0" URL (cs278)
 * bug #62285 [HttpClient] Reject 3xx pushed responses (nicolas-grekas)
 * bug #62267 [Config] Use the empty string instead of null as an array offset (santysisi)
 * bug #62246 [HttpFoundation] Allow Request::setFormat() to override predefined formats (longwave)
 * bug #62242 [MonologBridge] Accept HttpExceptionInterface in HttpCodeActivationStrategy (GromNaN)
 * bug #62222 [Cache] fix ext-redis 6.2.0 compatibility (xabbuh)
 * bug #62197 [Validator] Fix call to undefined getParser() in YamlValidator (yoeunes)
 * bug #62201 [HtmlSanitizer] Remove `srcdoc` from allowed attributes (Spomky)

* 7.3.5 (2025-10-28)

 * bug #62153 [HttpFoundation] Fix issue where ServerEvent with "0" data is not sent (santysisi)
 * bug #62145 [Mailer] Fix parsing message ids in SMTP responses (hacfi)
 * bug #62096 [Cache] fix compatibility with Relay 0.12.1 (xabbuh)
 * bug #62078 [FrameworkBundle] Fix secrets:encrypt-from-local (nicolas-grekas)
 * bug #62028 [Validator] Update regular expression in URL validator (mjaschen)
 * bug #62087 [Cache] fix compatibility with Relay 0.12.1 (xabbuh)
 * bug #62083 [TypeInfo] Fix resolving use statements with line breaks (ostrolucky)
 * bug #62054 [AssetMapper] Fix parsing `@import` that don't use url() (nicolas-grekas)
 * bug #62058 [Console] Ensure `SHELL_VERBOSITY` is always restored properly (ttskch)
 * bug #62037  Fix generating logout link with stateless csrf (pierredup)
 * bug #62041 [DebugBundle] Wire `DumpDataCollector`'s `webMode` argument (HypeMC)
 * bug #62038 [Translation][Loco] filter should be empty when filtering on all domains (atomiix)
 * bug #62003 [Serializer] Fix unexpected type in denormalization errors when float|int union type used in constructor with non numeric string in form-data request (d-mitrofanov-v)
 * bug #61990 [Cache][RedisTagAwareAdapter] Add Predis2 Replication Interface check (BrianMwit)
 * bug #61939 [FrameworkBundle] fix using lock from service id when previous locks used env vars (AydinHassan)
 * bug #61970 [Cache] fix compatibility with RelayCluster 0.11 and 0.12 (xabbuh)
 * bug #61964 [PropertyInfo][TypeInfo] Fix resolving constructor type with templates (HypeMC)
 * bug #61960 [WebProfilerBundle] ”finish” errored requests (MatTheCat)
 * bug #61954 [TypeInfo] Fix type alias with template resolving (mtarld)
 * bug #61924 [Mailer] Revert " Fix memory leak with `mailer.message_logger_listener`" (kochen)
 * bug #61943 [TypeInfo] ArrayShape can resolve key type as callable instead of string (Dean151)
 * bug #61947 [Cache] fix Relay Cluster 0.12 compatibility (xabbuh)
 * bug #61945 [Cache] fix compatibility with Relay 0.12 (xabbuh)
 * bug #61928 [Form] keep labels from configured choices (xabbuh)
 * bug #61889 [Serializer] Fix discriminator class mapping with allow_extra_attributes=false (chris54721)
 * bug #61861 [Console] Ensure terminal is usable after termination signal (johnstevenson)
 * bug #61912 [FrameworkBundle] Fix support of dumping workflow when workflow is decorated by TraceableWorkflow (lyrixx)
 * bug #61876 [Mailer][MailJet] Fix forbidden headers case-sensitive comparison (benjamintoussaint)
 * bug #61874 [Scheduler] Don’t get next run date from `null` (MatTheCat)
 * bug #61875 [Form] do not cast too big floats to int (xabbuh)
 * bug #61869 [JsonPath] do not pass more than one byte to ord() (xabbuh)
 * bug #61856 [Console] do not pass the empty string to ord() (xabbuh)
 * bug #61855 [DoctrineBridge][Yaml] don't cast strings exceeding the min/max int ranges (xabbuh)
 * bug #61844  do not coerce NAN to other types (xabbuh)

* 7.3.4 (2025-09-27)

 * bug #61830 [Security] Fix preload warning in `AuthorizationChecker` (MatTheCat)
 * bug #61825 [DoctrineBridge] Make `EntityUserProvider`s pass attributes to their loader (MatTheCat)
 * bug #61818 [Notifier] Rename LOX24RequestParser to Lox24RequestParser (nicolas-grekas)
 * bug #61808 [Config] Fix incorrect serialized data mangling (aboks)
 * bug #61793  [AssetMapper] Prevent duplicate entries in module preloads (xDeSwa)
 * bug #61785 [ObjectMapper] Preserve non-promoted constructor parameters (rvanlaak)
 * bug #60515 [Mailer] Fix memory leak with `mailer.message_logger_listener` (andrew-demb)
 * bug #61757 [FrameworkBundle] Perform-no-deep-merging on workflow transitions' from/to configs (nicolas-grekas)
 * bug #61766  Fix ord()-related PHP 8.5 deprecations (nicolas-grekas)
 * bug #61368 [HttpKernel] Refine Vary header check to skip special handling of 'Accept-Language' when it's the only entry and '_vary_by_language' is `true`  in `CacheAttributeListener` (santysisi)
 * bug #61752 [PropertyInfo] Fix getting type from constructor of parent class in `PhpStanExtractor` (wuchen90)
 * bug #61746 [Serializer] Fix unknown type in denormalization errors when union type used in constructor (d-mitrofanov-v)
 * bug #61724 [Console] Fix handling of `\E` in Bash completion (HypeMC)
 * bug #61518 [HttpKernel] Handle an array vary header in the http cache store for write (philpichet)
 * bug #61736 [PhpUnitBridge] do not try to modify the result of a PhptTestCase (xabbuh)
 * bug #61728 [TypeInfo] Fix issue with merging union type with a nullable union type (matijn-made)
 * bug #61731 [PhpUnitBridge] Fix gathering deprecation in phpt (nicolas-grekas)
 * bug #61729 [PhpUnitBridge] Silence deprecation of __sleep/wakeup() (nicolas-grekas)
 * bug #61727  Replace __sleep/wakeup() by __(un)serialize() for throwing and internal usages (nicolas-grekas)
 * bug #61714 [SecurityBundle] Fix semantic configuration for singulars/plurals in XML (nicolas-grekas)
 * bug #61132 [JsonPath] Make the component RFC compliant (alexandre-daubois)
 * bug #60055 [MonologBridge] Make `ConsoleHandler` not handle messages at SILENT verbosity (okhoshi)
 * bug #61701 [SecurityBundle] Add missing `fixXmlConfig()` call for `issuer` (OskarStark)
 * bug #61693 [Console] Don’t append a new line to test inputs ending with an EOT (MatTheCat)
 * bug #61596 [FrameworkBundle] Normalize workflow places separately (KevinVanSonsbeek)
 * bug #61690 [Console] Don’t automatically append EOT to multiline test inputs (MatTheCat)
 * bug #61667 [Config] Fix `GlobResource` pattern with trailing slash (HypeMC)
 * bug #61658 [Messenger] map legacy options to the "sentinel" key when parsing DSNs (xabbuh)
 * bug #61659 [Security] Fix `HttpUtils::createRequest()` when the base request is forwarded (MatTheCat)
 * bug #61653 [Routing] Don't rebuild cache when controller action body changes (HypeMC)
 * bug #61645  Replace backtick operator, deprecated in PHP 8.5, with shell_exec() (iluuu1994)
 * bug #61617 [Validator] fall back to legacy options handling if configured named arguments do not match (xabbuh)
 * bug #61097 [Serializer] Fix normalizing objects with accessors having the same name as a property (RafaelKr)
 * bug #61615 [DependencyInjection] Fix optimizing ClassExistenceResource (nicolas-grekas)
 * bug #61614 [SecurityBundle] Prevent accessing the tracked token storage when collecting data (MatTheCat)
 * bug #61607 [Config] Fix `ReflectionClassResource` hash validation (HypeMC)
 * bug #61605 [Cache] Fix internal representation of non-static values (nicolas-grekas)
 * bug #61599 [Cache] Make `TagAwareAdapter` registrable as a service (a.dmitryuk)
 * bug #61595 [Security] Pass attributes to nested `ChainUserProvider`s (valtzu)
 * bug #61580 [JsonStreamer] Fix encoding iterable lists (mtarld)
 * bug #61232 [Messenger] Firebird Database - incompatibility with expected lowercase columns (DSsatwareAG)
 * bug #61583 [DoctrineBridge] Fix exception catch when deleting temporary table in the sameDatabaseChecker (GromNaN)
 * bug #61585 [HttpFoundation][SQLSRV] Change column type from `TEXT` to `STRING` (Matt-PMCT)
 * bug #61571 [Serializer] Fix dealing with asymmetric visilibity for properties (santysisi)
 * bug #60766 [DependencyInjection] Respect original service class when a proxy is defined (lyrixx)
 * bug #61561 [JsonStreamer] Fix decoding iterable lists (mtarld)
 * bug #61573 [Inflector][String] Fix edge cases (OskarStark)
 * bug #61548 [Security] Fix attribute-based chained user providers (valtzu)

* 7.3.3 (2025-08-29)

 * bug #61543 [TypeInfo] Prevent interfaces extending BackedEnum to be treated as BackedEnums (ettoredn)
 * bug #61520 [Yaml] Fix scope resolution operator in flow mapping keys (MatTheCat)
 * bug #61534 [HttpClient] Fix PHP 8.5 deprecation using str_increment() (nicolas-grekas)
 * bug #61529 [FrameworkBundle] Don’t collect CLI profiles if the profiler is disabled (MatTheCat)
 * bug #61526 [Serializer] Don't fallback to default serializer if tags specify a named one (HypeMC)
 * bug #60211 [Messenger] Fix Oracle errors 'ORA-00955: Name is already used by an existing object' with Doctrine transport (atgitwk)
 * bug #61033 [Console] Restore `SHELL_VERBOSITY` after a command is ran (lyrixx)
 * bug #61501 [Console] Fix testing multiline question (MatTheCat)
 * bug #61503 [String] Fix nodes singular (ruudk)
 * feature #61486 [Security] Ignore target route when exiting impersonation (MatTheCat)
 * bug #61459 [String] Fix issues singular (ruudk)
 * bug #61426 [Intl] Take timezoneTypes’ ianaMap into account (MatTheCat)
 * bug #61422 [WebProfilerBundle] Hide WDT clearer when it is hidden (MatTheCat)
 * bug #61381 [HttpKernel] #[MapUploadedFile] throws http exception on empty files array if argument not nullable nor has default value (hwawshy)
 * bug #61453 [VarExporter] Fix serializing classes with __serialize() returning unprefixed private properties (nicolas-grekas)
 * bug #61447 [String] specific fix to avoid 'outag' when inflecting 'outages' (PhilETaylor)
 * bug #61115 [FrameworkBundle] Make `cache:warmup` warm up read-only caches (MatTheCat)
 * bug #61411 [DependencyInjection] Don’t autowire excluded services (MatTheCat)
 * bug #61401 [Process] Enhance hasSystemCallBeenInterrupted function for non-english locale (christianseel)
 * bug #61405  Remove calls to no-op functions, deprecated in PHP 8.5 (nicolas-grekas)
 * bug #61402  Remove calls to deprecated methods of SplObjectStorage (nicolas-grekas)
 * bug #61375 [TypeInfo] Fix converting list to string (ruudk)
 * bug #61310 [ObjectMapper] read source metadata before transform (soyuka, rvanlaak)
 * bug #61355 [WebProfilerBundle] Fix toolbar not rendering after replacing it (aleho)
 * bug #58547 [HtmlSanitizer] Fix `force_attributes` not replacing existing attribute in initial data (tgalopin)
 * bug #61335 [Mailer] [Resend] Add friendly name in the `to` field (antalaron)
 * bug #61351 [VarDumper] Fix dumping objects from the DOM extension (nicolas-grekas)
 * bug #61291 [Messenger] Remove fix `NoAutoAckStamp` handling in `Worker::flush()` (wazum)
 * bug #61307 [Scheduler] Fix `scheduler.task` tag arguments optionality (Jan Pintr)
 * bug #61304 [PhpUnitBridge] Call Reflection*::setAccessible() only for PHP < 8.1 (W0rma)
 * bug #61319 [Console] [Table] Don't split grapheme clusters (schlndh)

* 7.3.2 (2025-07-31)

 * bug #61276 [DependencyInjection] Escape parameters before resolving env placeholders (MatTheCat)
 * bug #61268 [Console] [Table] Fix unnecessary wrapping (schlndh)
 * bug #61085 [Lock] Fix using fractional TTLs (manuelderuiter)
 * bug #61271 [Messenger] disable detecting modified indexes with DBAL 4.3 (xabbuh)
 * bug #61242 [Console] [Table] Fix invalid UTF-8 due to text wrapping (schlndh)
 * bug #61234 [Cache] RedisTrait::doFetch should use pipeline with GET's instead of MGET for Relay\Cluster (dorrogeray)
 * bug #61246 [VarDumper] Use unique identifier for `RequestContextProvider` (ToshY)
 * bug #61261 [FrameworkBundle] Fix `lint:container --resolve-env-vars` (MatTheCat)
 * bug #61080 [Console] Fix `TreeHelper::addChild` when providing a string (jtattevin)
 * bug #60296 [Serializer] Handle invalid mapping type property type (KorvinSzanto)
 * bug #58995 [Config] Do not generate unreachable configuration paths (bobvandevijver)
 * bug #60867 [WebProfilerBundle] Fix missing indent on non php files opended in the profiler (phcorp)
 * bug #61233 [ObjectMapper] skip reading uninitialized values (soyuka)
 * bug #61199 [JsonPath] Fix parsing invalid Unicode codepoints (nicolas-grekas)
 * bug #61223 [Mailer][Brevo] Update Webhook IPs (jarbey)
 * bug #61201 [Console] Fix JSON description for negatable input flags (nicolas-grekas)
 * bug #61220 [Cache] fix compatibility with different Relay versions (xabbuh)
 * bug #61194 [Security] Fix added $token argument to UserCheckerInterface::checkPostAuth() (nicolas-grekas)
 * bug #61146 [ObjectMapper] initialize lazy objects (soyuka)
 * bug #61161 [Lock] Fallback to `eval` when `LOAD` fails due to missing script (santysisi)
 * bug #61151 [ObjectMapper] update promoted properties w/ an object as target (soyuka)
 * bug #61158 [FrameworkBundle] Add missing html5-allow-no-tld to XSD file (nicolas-grekas)
 * bug #61144 [VarDumper] Fix dumping on systems that don't have a working iconv (nicolas-grekas)
 * bug #60798 [JsonPath] Handle slice selector overflow (alexandre-daubois)
 * bug #61138 [Console] fix profiler with overridden `run()` method (vinceAmstoutz)
 * bug #61079 [Config] Fix support for attributes on class constants and enum cases (ruudk)
 * bug #61131 [Validator] error if the fields option is missing for the Collection constraint (xabbuh)
 * bug #61111 [Translation] fix support of `TranslatableInterface` in `IdentityTranslator` (VincentLanglet)
 * bug #61117 [Validator] fix handling required options (xabbuh)
 * bug #61121 [DependencyInjection] Fix proxying services defined with an abstract class and a factory (nicolas-grekas)
 * bug #61120 [DoctrineBridge] Prevent idle connection listener from running on subrequest (a.dmitryuk, dmitryuk)
 * bug #61106 Fix `@var` phpdoc (fabpot)
 * bug #61091 [Lock] [MongoDB] Enforce readPreference=primary and writeConcern=majority (notrix)
 * bug #61105 [FrameworkBundle] fix phpdoc in `MicroKernelTrait` (santysisi)
 * bug #61014 [TypeInfo] Reuse `CollectionType::mergeCollectionValueTypes` for `ConstFetchNode` (norkunas)
 * bug #61076 [ExpressionLanguage] Fix dumping of null safe operator (ivantsepp)
 * bug #60856 [ObjectMapper] handle non existing property errors (soyuka)
 * bug #60802 [JsonPath] Improve escape sequence validation in name selector (alexandre-daubois)
 * bug #60741 [Scheduler] Fix `#[AsCronTask]` not passing arguments to command (Jan Pintr, jan-pintr)
 * bug #61056 [Validator] Allow mixed root on `CompoundConstraintTestCase` validator (thePanz)
 * bug #61028 [Serializer] Fix `readonly` property initialization from incorrect scope (santysisi)
 * bug #61073 [VarExporter] Dump implicit-nullable types as explicit to prevent the corresponding deprecation (nicolas-grekas)
 * bug #61062 [Brevo Mailer] Webhook IP Addresses have changed (richardhj)
 * bug #61004 [TypeInfo] Fix imported-only alias resolving (mtarld)
 * bug #60975 [Form] Fix precision loss when rounding large integers in `NumberToLocalizedStringTransformer` (OskarStark)
 * bug #61001 [JsonStreamer] Fix nested generated foreach loops (mttsch)
 * bug #61036 [ObjectMapper] Correctly manage constructor initialization (alanpoulain)
 * bug #60953 [DoctrineBridge] Restore compatibility with Doctrine ODM (pepeh)
 * bug #61020 [Doctrine][FrameworkBundle][Serializer][Validator] Increase minimum version of type-info component (mitelg)
 * bug #61031 [HttpClient] return early if handle has been cleaned up before (xabbuh)
 * bug #60998 [TwigBridge] fix command option mode (`InputOption::VALUE_REQUIRED`) (gharlan)
 * bug #60961 [TypeInfo] Fix `Type::fromValue` with empty array (norkunas)
 * bug #60956 [TypeInfo] Fix `Type::fromValue` incorrectly setting object type instead of enum (norkunas)
 * bug #60958 [Serializer] remove return type from `AbstractObjectNormalizer::getAllowedAttributes()` (xabbuh)
 * bug #60507 [Console][Messenger] Fix: Allow `UnrecoverableExceptionInterface` to bypass retry in `RunCommandMessageHandler` (santysisi)

* 7.3.1 (2025-06-28)

 * bug #60044 [Console] Table counts wrong column width when using colspan and `setColumnMaxWidth()` (vladimir-vv)
 * bug #60042 [Console] Table counts wrong number of padding symbols in `renderCell()` method when cell contain unicode variant selector (vladimir-vv)
 * bug #60594 [Cache] Fix using a `ChainAdapter` as an adapter for a pool (IndraGunawan)
 * bug #60483 [HttpKernel] Fix `#[MapUploadedFile]` handling for optional file uploads (santysisi)
 * bug #60413 [Serializer] Fix collect_denormalization_errors flag in defaultContext (dmbrson)
 * bug #60820 [TypeInfo] Fix handling `ConstFetchNode` (norkunas)
 * bug #60908 [Uid] Improve entropy of the increment for UUIDv7 (nicolas-grekas)
 * bug #60914 [Console] Fix command option mode (InputOption::VALUE_REQUIRED) (gharlan)
 * bug #60919 [VarDumper] Avoid deprecated call in PgSqlCaster (vrana)
 * bug #60909 [TypeInfo] use an EOL-agnostic approach to parse class uses (xabbuh)
 * bug #60888 [Intl] Fix locale validator when canonicalize is true (rdavaillaud)
 * bug #60885 [Notifier] Update fake SMS transports to use contracts event dispatcher (paulferrett)
 * bug #60894 [FrameworkBundle] also deprecate the internal rate limiter factory alias (xabbuh)
 * bug #60875 [HttpFoundation] Revert " Emit PHP warning when `Response::sendHeaders()` is called while output has already been sent" (nicolas-grekas)
 * bug #60840 [Validator] Add missing HasNamedArguments to some constraints (jkgroupe)
 * bug #60859 [TwigBundle] fix preload unlinked class `BinaryOperatorExpressionParser` (Grummfy)
 * bug #60772 [Mailer] [Transport] Send clone of `RawMessage` instance in `RoundRobinTransport` (jnoordsij)
 * bug #60842 [DependencyInjection] Fix generating adapters of functional interfaces (nicolas-grekas)
 * bug #60809 [Serializer] Fix `TraceableSerializer` when called from a callable inside `array_map` (OrestisZag)
 * bug #60831 [ObjectMapper] Fix parameter passed to class level transform (mttsch)
 * bug #60511 [Serializer] Add support for discriminator map in property normalizer (ruudk)
 * bug #60780 [FrameworkBundle] Fix argument not provided to `add_bus_name_stamp_middleware` (maxbaldanza)
 * bug #60826 [DependencyInjection] Fix inlining when public services are involved (nicolas-grekas)
 * bug #60806 [HttpClient] Limit curl's connection cache size (nicolas-grekas)
 * bug #60699 [JsonPath] Improve compliance to the RFC test suite (alexandre-daubois)
 * bug #60705 [FrameworkBundle] Fix allow `loose` as an email validation mode (rhel-eo)
 * bug #60759 [Messenger] Fix float value for worker memory limit (ro0NL)
 * bug #60785 [Security] Handle non-callable implementations of `FirewallListenerInterface` (MatTheCat)
 * bug #60781 [DomCrawler] Allow selecting `button`s by their `value` (MatTheCat)
 * bug #60775 [Validator] flip excluded properties with keys with Doctrine-style constraint config (xabbuh)
 * bug #60774 [FrameworkBundle] Fixes getting a type error when the secret you are trying to reveal could not be decrypted (jack-worman)
 * bug #60504 [JsonPath] Fix subexpression evaluation in filters (alexandre-daubois)
 * bug #60779 Silence E_DEPRECATED and E_USER_DEPRECATED (nicolas-grekas)
 * bug #60502 [HttpCache] Hit the backend only once after waiting for the cache lock (mpdude)
 * bug #60771 [Runtime] fix compatibility with Symfony 7.4 (xabbuh)
 * bug #60719 [JsonPath] Fix support for comma separated indices (alexandre-daubois)
 * bug #59910 [Form] Keep submitted values when `keep_as_list` option of collection type is enabled (kells)
 * bug #60638 [Form] Fix `keep_as_list` when data is not an array (MatTheCat)
 * bug #60691 [DependencyInjection] Fix `ServiceLocatorTagPass` indexes handling (MatTheCat)
 * bug #60676 [Form] Fix handling the empty string in NumberToLocalizedStringTransformer (gnat42)
 * bug #60694 [Intl] Add missing currency (NOK) localization (en_NO) (llupa)
 * bug #60681 [JsonPath] Better handling of unicode chars in expressions (alexandre-daubois)
 * bug #60711 [Intl] Ensure data consistency between alpha and numeric codes (llupa)
 * bug #60724 [VarDumper] Fix dumping LazyObjectState when using VarExporter v8 (nicolas-grekas)
 * bug #60693 [FrameworkBundle] ensureKernelShutdown in tearDownAfterClass (cquintana92)
 * bug #60688 [Security] Keep roles when serializing tokens (nicolas-grekas)
 * bug #60668 [JsonPath] Always use brackets notation with `JsonPath::key()` (alexandre-daubois)
 * bug #60641 [TypeInfo] Fix type alias resolving (mtarld)
 * bug #60564 [FrameworkBundle] ensureKernelShutdown in tearDownAfterClass (cquintana92)
 * bug #60632 [TypeInfo] Fix merging collection value types with union types (mtarld)
 * bug #60645 [PhpUnitBridge] Skip bootstrap for PHPUnit >=10 (HypeMC)
 * bug #60646 [FrameworkBundle] don't register `SchedulerTriggerNormalizer` without `symfony/serializer` (xabbuh)
 * bug #60655 [TypeInfo] Handle `key-of` and `value-of` types (mtarld)
 * bug #60640 [Mailer] use STARTTLS for SMTP with MailerSend (xabbuh)
 * bug #60648 [Yaml] fix support for years outside of the 32b range on x86 arch on PHP 8.4 (nicolas-grekas)
 * bug #60626 [Ldap] Fix `LdapUser::isEqualTo` (MatTheCat)
 * bug #60625 [FrameworkBundle] set NamespacedPoolInterface alias to cache.app (IndraGunawan)
 * bug #60607 [WebProfilerBundle] Fix toolbar with ajax requests not closing (HypeMC)
 * bug #60606 [HttpKernel] Fix Symfony 7.3 end of maintenance date (axzx)
 * bug #60616 skip interactive questions asked by Composer (xabbuh)
 * bug #60617 [HttpKernel] pass log level instead of exception to resolve the logger (xabbuh)
 * bug #60569 [HttpKernel] Do not superseed private cache-control when no-store is set (alexander-schranz)
 * bug #60584 [DependencyInjection] Make `YamlDumper` quote resolved env vars if necessary (MatTheCat)
 * bug #60588 [Notifier][Clicksend] Fix lack of recipient in case DSN does not have optional LIST_ID param (alifanau)
 * bug #60547 [HttpFoundation] Fixed 'Via' header regex (thecaliskan)

* 7.3.0 (2025-05-29)

 * bug #60549 [Translation] Add intl-icu fallback for MessageCatalogue metadata (pontus-mp)
 * bug #60571 [ErrorHandler] Do not transform file to link if it does not exist (lyrixx)
 * bug #60542 [Webhook] Fix controller service name (HypeMC)

* 7.3.0-RC1 (2025-05-25)

 * bug #60529 [AssetMapper] Fix SequenceParser possible infinite loop (smnandre)
 * bug #60532 [Routing] Fix inline default `null` (HypeMC)
 * bug #60535 [DoctrineBridge] Fix resetting the manager when using native lazy objects (HypeMC)
 * bug #60500 [PhpUnitBridge] Fix cleaning up mocked features with attributes (HypeMC)
 * bug #60330 [FrameworkBundle] skip messenger deduplication middleware registration when no "default" lock is configured (lyrixx)
 * bug #60494 [Messenger] fix: Add argument as integer (overexpOG)
 * bug #60524 [Notifier] Fix Clicksend transport (BafS)
 * bug #60479 [FrameworkBundle] object mapper service definition without form (soyuka)
 * bug #60478 [Validator] add missing `$extensions` and `$extensionsMessage` to the `Image` constraint (xabbuh)
 * bug #60491 [ObjectMapper] added earlier skip to allow if=false when using source mapping (maciekpaprocki)
 * bug #60484 [PhpUnitBridge] Clean up mocked features only when ``@group`` is present (HypeMC)
 * bug #60490 [PhpUnitBridge] set path to the PHPUnit autoload file (xabbuh)
 * bug #60489 [FrameworkBundle] Fix activation strategy of traceable decorators (nicolas-grekas)
 * feature #60475 [Validator] Revert Slug constraint (wouterj)
 * feature #60105 [JsonPath] Add `JsonPathAssertionsTrait` and related constraints (alexandre-daubois)
 * bug #60423 [DependencyInjection] Make `DefinitionErrorExceptionPass` consider `IGNORE_ON_UNINITIALIZED_REFERENCE` and `RUNTIME_EXCEPTION_ON_INVALID_REFERENCE` the same (MatTheCat)
 * bug #60439 [FrameworkBundle] Fix declaring field-attr tags in xml config files (nicolas-grekas)
 * bug #60428 [DependencyInjection] Fix missing binding for ServiceCollectionInterface when declaring a service subscriber (nicolas-grekas)
 * bug #60426 [Validator] let the `SlugValidator` accept `AsciiSlugger` results (xabbuh)
 * bug #60421 [VarExporter] Fixed lazy-loading ghost objects generation with property hooks (cheack)
 * bug #60419 [SecurityBundle] normalize string values to a single ExposeSecurityLevel instance (xabbuh)
 * bug #60266 [Security] Exclude remember_me from default login authenticators (santysisi)
 * bug #60407 [Console] Invokable command `#[Option]` adjustments (kbond)
 * bug #60400 [Config] Fix generated comment for multiline "info" (GromNaN)
 * bug #60260 [Serializer] Prevent `Cannot traverse an already closed generator` error by materializing Traversable input (santysisi)
 * bug #60292 [HttpFoundation] Encode path in `X-Accel-Redirect` header (Athorcis)
 * bug #60401 Passing more than one Security attribute is not supported (santysisi)

* 7.3.0-BETA2 (2025-05-10)

 * bug #58643 [SecurityBundle] Use Composer `InstalledVersions` to check if flex is installed (andyexeter)
 * feature #54276 [Workflow] Add support for executing custom workflow definition validators during the container compilation (lyrixx)
 * feature #52981 [FrameworkBundle] Make `ValidatorCacheWarmer` and `SerializeCacheWarmer` use `kernel.build_dir` instead of `kernel.cache_dir` (Okhoshi)
 * feature #54384 [TwigBundle] Use `kernel.build_dir` to store the templates known at build time (Okhoshi)
 * bug #60275 [DoctrineBridge] Fix UniqueEntityValidator Stringable identifiers (GiuseppeArcuti, wkania)
 * feature #59602 [Console] `#[Option]` rules & restrictions (kbond)
 * feature #60389 [Console] Add support for `SignalableCommandInterface` with invokable commands (HypeMC)
 * bug #60293 [Messenger] fix asking users to select an option if `--force` option is used in `messenger:failed:retry` command (W0rma)
 * bug #60392 [DependencyInjection][FrameworkBundle] Fix precedence of `App\Kernel` alias and ignore `container.excluded` tag on synthetic services (nicolas-grekas)
 * bug #60379 [Security] Avoid failing when PersistentRememberMeHandler handles a malformed cookie (Seldaek)
 * bug #60308 [Messenger] Fix integration with newer versions of Pheanstalk (HypeMC)
 * bug #60373 [FrameworkBundle] Ensure `Email` class exists before using it (Kocal)
 * bug #60365 [FrameworkBundle] ensure that all supported e-mail validation modes can be configured (xabbuh)
 * bug #60350 [Security][LoginLink] Throw `InvalidLoginLinkException` on invalid parameters (davidszkiba)
 * bug #60366 [Console] Set description as first parameter to `Argument` and `Option` attributes (alamirault)
 * bug #60361 [Console] Ensure overriding `Command::execute()` keeps priority over `__invoke()` (GromNaN)
 * feature #60028 [ObjectMapper] Condition to target a specific class  (soyuka)
 * feature #60344 [Console] Use kebab-case for auto-guessed input arguments/options names (chalasr)
 * bug #60340 [String] fix EmojiTransliterator return type compatibility with PHP 8.5 (xabbuh)
 * bug #60322 [FrameworkBundle] drop the limiters option for non-compound rater limiters (xabbuh)

* 7.3.0-BETA1 (2025-05-02)

 * feature #60232 Add PHP config support for routing (fabpot)
 * feature #60102 [HttpFoundation] Add `UriSigner::verify()` that throws named exceptions (kbond)
 * feature #60222 [FrameworkBundle][HttpFoundation] Add Clock support for `UriSigner` (kbond)
 * feature #60226 [Uid] Add component-specific exception classes (rela589n)
 * feature #60163 [TwigBridge] Allow attachment name to be set for inline images (aleho)
 * feature #60186 [DependencyInjection] Add "when" argument to #[AsAlias] (Zuruuh)
 * feature #60195 [Workflow] Deprecate `Event::getWorkflow()` method (lyrixx)
 * feature #60193 [Workflow] Add a link to mermaid.live from the profiler (lyrixx)
 * feature #60188 [JsonPath] Add two utils methods to `JsonPath` builder (alexandre-daubois)
 * feature #60018 [Messenger] Reset peak memory usage for each message (TimWolla)
 * feature #60155 [FrameworkBundle][RateLimiter] compound rate limiter config (kbond)
 * feature #60171 [FrameworkBundle][RateLimiter] deprecate `RateLimiterFactory` alias (kbond)
 * feature #60139 [Runtime] Support extra dot-env files (natepage)
 * feature #60140 Notifier mercure7.3 (ernie76)
 * feature #59762 [Config] Add `NodeDefinition::docUrl()` (alexandre-daubois)
 * feature #60099 [FrameworkBundle][RateLimiter] default `lock_factory` to `auto` (kbond)
 * feature #60112 [DoctrineBridge] Improve exception message when `EntityValueResolver` gets no mapping information (MatTheCat)
 * feature #60103 [Console] Mark `AsCommand` attribute as ``@final`` (Somrlik, GromNaN)
 * feature #60069 [FrameworkBundle] Deprecate setting the `collect_serializer_data` to `false` (mtarld)
 * feature #60087 [TypeInfo] add TypeFactoryTrait::arrayKey() (xabbuh)
 * feature #42124 [Messenger] Add `$stamps` parameter to `HandleTrait::handle` (alexander-schranz)
 * feature #58200 [Notifier] Deprecate sms77 Notifier bridge (MrYamous)
 * feature #58380 [WebProfilerBundle] Update the logic that minimizes the toolbar (javiereguiluz)
 * feature #60039 [TwigBridge] Collect all deprecations with `lint:twig` command (Fan2Shrek)
 * feature #60081 [FrameworkBundle] Enable controller service with `#[Route]` attribute (GromNaN)
 * feature #60076 [Console] Deprecate returning a non-int value from a `\Closure` function set via `Command::setCode()` (yceruto)
 * feature #59655 [JsonPath] Add the component (alexandre-daubois)
 * feature #58805 [TwigBridge][Validator] Add the Twig constraint and its validator (sfmok)
 * feature #54275 [Messenger] [Amqp] Add default exchange support (ilyachase)
 * feature #60052 [Mailer][TwigBridge] Revert "Add support for translatable objects" (kbond)
 * feature #59967 [Mailer][TwigBridge] Add support for translatable subject (norkunas)
 * feature #58654 [FrameworkBundle] Binding for Object Mapper component (soyuka)
 * feature #60040 [Messenger] Use newer version of Beanstalkd bridge library (HypeMC)
 * feature #52748 [TwigBundle] Enable `#[AsTwigFilter]`, `#[AsTwigFunction]` and `#[AsTwigTest]` attributes to configure runtime extensions (GromNaN)
 * feature #59831 [Mailer][Mime] Refactor S/MIME encryption handling in `SMimeEncryptionListener` (Spomky)
 * feature #59981 [TypeInfo] Add `ArrayShapeType::$sealed` (mtarld)
 * feature #51741 [ObjectMapper] Object to Object mapper component (soyuka)
 * feature #57309 [FrameworkBundle][HttpKernel] Allow configuring the logging channel per type of exceptions (Arkalo2)
 * feature #60007 [Security] Add methods param in IsCsrfTokenValid attribute (Oviglo)
 * feature #59900 [DoctrineBridge] add new `DatePointType` Doctrine type (garak)
 * feature #59904 [Routing] Add alias in `{foo:bar}` syntax in route parameter (eltharin)
 * feature #59978 [Messenger] Add `--class-filter` option to the `messenger:failed:remove` command (arnaud-deabreu)
 * feature #60024 [Console] Add support for invokable commands in `LockableTrait` (yceruto)
 * feature #59813 [Cache] Enable namespace-based invalidation by prefixing keys with backend-native namespace separators (nicolas-grekas)
 * feature #59902 [PropertyInfo] Deprecate `Type` (mtarld, chalasr)
 * feature #59890 [VarExporter] Leverage native lazy objects (nicolas-grekas)
 * feature #54545 [DoctrineBridge] Add argument to `EntityValueResolver` to set type aliases (NanoSector)
 * feature #60011 [DependencyInjection] Enable multiple attribute autoconfiguration callbacks on the same class (GromNaN)
 * feature #60020 [FrameworkBundle] Make `ServicesResetter` autowirable (lyrixx)
 * feature #59929 [RateLimiter] Add `CompoundRateLimiterFactory` (kbond)
 * feature #59993 [Form] Add input with `string` value in `MoneyType` (StevenRenaux)
 * feature #59987 [FrameworkBundle] Auto-exclude DI extensions, test cases, entities and messenger messages (nicolas-grekas)
 * feature #59827 [TypeInfo] Add `ArrayShapeType` class (mtarld)
 * feature #59909 [FrameworkBundle] Add `--method` option to `debug:router` command (santysisi)
 * feature #59913 [DependencyInjection] Leverage native lazy objects for lazy services (nicolas-grekas)
 * feature #53425 [Translation] Allow default parameters (Jean-Beru)
 * feature #59464 [AssetMapper] Add `--dry-run` option on `importmap:require` command (chadyred)
 * feature #59880 [Yaml] Add the `Yaml::DUMP_FORCE_DOUBLE_QUOTES_ON_VALUES` flag to enforce double quotes around string values (dkarlovi)
 * feature #59922 [Routing] Add `MONGODB_ID` to requirement patterns (GromNaN)
 * feature #59842 [TwigBridge] Add Twig `field_id()` form helper (Legendary4226)
 * feature #59869 [Cache] Add support for `valkey:` / `valkeys:` schemes (nicolas-grekas)
 * feature #59862 [Messenger] Allow to close the transport connection (andrew-demb)
 * feature #59857 [Cache] Add `\Relay\Cluster` support (dorrogeray)
 * feature #59863 [JsonEncoder] Rename the component to `JsonStreamer` (mtarld)
 * feature #52749 [Serializer] Add discriminator map to debug commmand output (jschaedl)
 * feature #59871 [Form] Add support for displaying nested options in `DebugCommand` (yceruto)
 * feature #58769 [ErrorHandler] Add a command to dump static error pages (pyrech)
 * feature #54932 [Security][SecurityBundle] OIDC discovery (vincentchalamon)
 * feature #58485 [Validator] Add `filenameCharset` and `filenameCountUnit` options to `File` constraint (IssamRaouf)
 * feature #59828 [Serializer] Add `defaultType` to `DiscriminatorMap` (alanpoulain)
 * feature #59570 [Notifier][Webhook] Add Smsbox support (alanzarli)
 * feature #50027 [Security] OAuth2 Introspection Endpoint (RFC7662) (Spomky)
 * feature #57686 [Config] Allow using an enum FQCN with `EnumNode` (alexandre-daubois)
 * feature #59588 [Console] Add a Tree Helper + multiple Styles  (smnandre)
 * feature #59618 [OptionsResolver] Deprecate defining nested options via `setDefault()` use `setOptions()` instead (yceruto)
 * feature #59805 [Security] Improve DX of recent additions (nicolas-grekas)
 * feature #59822 [Messenger] Add options to specify SQS queue attributes and tags (TrePe0)
 * feature #59290 [JsonEncoder] Replace normalizers by value transformers (mtarld)
 * feature #59800 [Validator] Add support for closures in `When` (alexandre-daubois)
 * feature #59814 [Framework] Deprecate the `framework.validation.cache` config option (alexandre-daubois)
 * feature #59804 [TypeInfo] Add type alias support (mtarld)
 * feature #59150 [Security] Allow using a callable with `#[IsGranted]` (alexandre-daubois)
 * feature #59789 [Notifier] [Bluesky] Return the record CID as additional info (javiereguiluz)
 * feature #59526 [Messenger] [AMQP] Add TransportMessageIdStamp logic for AMQP (AurelienPillevesse)
 * feature #59771 [Security] Add ability for voters to explain their vote (nicolas-grekas)
 * feature #59768 [Messenger][Process] add `fromShellCommandline` to `RunProcessMessage` (Staormin)
 * feature #59377 [Notifier] Add Matrix bridge (chii0815)
 * feature #58488 [Serializer] Fix deserializing XML Attributes into string properties (Hanmac)
 * feature #59657 [Console] Add markdown format to Table (amenk)
 * feature #59274 [Validator] Allow Unique constraint validation on all elements (Jean-Beru)
 * feature #59704 [DependencyInjection] Add `Definition::addExcludedTag()` and `ContainerBuilder::findExcludedServiceIds()` for auto-discovering value-objects (GromNaN)
 * feature #49750 [FrameworkBundle] Allow to pass signals to `StopWorkerOnSignalsListener` in XML config and as plain strings (alexandre-daubois)
 * feature #59479 [Mailer] [Smtp] Add DSN param to enforce TLS/STARTTLS (ssddanbrown)
 * feature #59562 [Security] Support hashing the hashed password using crc32c when putting the user in the session (nicolas-grekas)
 * feature #58501 [Mailer] Add configuration for dkim and smime signers (elias-playfinder, eliasfernandez)
 * feature #52181 [Security] Ability to add roles in `form_login_ldap` by ldap group (Spomky)
 * feature #59712 [DependencyInjection] Don't skip classes with private constructor when autodiscovering (nicolas-grekas)
 * feature #50797 [FrameworkBundle][Validator] Add `framework.validation.disable_translation` option (alexandre-daubois)
 * feature #49652 [Messenger] Add `bury_on_reject` option to Beanstalkd bridge (HypeMC)
 * feature #51744 [Security] Add a normalization step for the user-identifier in firewalls (Spomky)
 * feature #54141 [Messenger] Introduce `DeduplicateMiddleware` (VincentLanglet)
 * feature #58546 [Scheduler] Add MessageHandler result to the `PostRunEvent` (bartholdbos)
 * feature #58743 [HttpFoundation] Streamlining server event streaming (yceruto)
 * feature #58939 [RateLimiter] Add `RateLimiterFactoryInterface` (alexandre-daubois)
 * feature #58717 [HttpKernel] Support `Uid` in `#[MapQueryParameter]` (seb-jean)
 * feature #59634 [Validator] Add support for the `otherwise` option in the `When` constraint (alexandre-daubois)
 * feature #59670 [Serializer] Add `NumberNormalizer` (valtzu)
 * feature #59679 [Scheduler] Normalize `TriggerInterface` as `string` (valtzu)
 * feature #59641 [Serializer] register named normalizer & denormalizer aliases (mathroc)
 * feature #59682 [Security] Deprecate UserInterface & TokenInterface's `eraseCredentials()` (chalasr, nicolas-grekas)
 * feature #59667 [Notifier] [Bluesky] Allow to attach website preview card (ppoulpe)
 * feature #58300 [Security][SecurityBundle] Show user account status errors (core23)
 * feature #59630 [FrameworkBundle] Add support for info on `ArrayNodeDefinition::canBeEnabled()` and `ArrayNodeDefinition::canBeDisabled()` (alexandre-daubois)
 * feature #59612 [Mailer] Add attachments support for Sweego Mailer Bridge (welcoMattic)
 * feature #59302 [TypeInfo] Deprecate `CollectionType` as list and not as array (mtarld)
 * feature #59481 [Notifier] Add SentMessage additional info (mRoca)
 * feature #58819 [Routing] Allow aliases in `#[Route]` attribute (damienfern)
 * feature #59004 [AssetMapper] Detect import with a sequence parser (smnandre)
 * feature #59601 [Messenger] Add keepalive support (silasjoisten)
 * feature #59536 [JsonEncoder] Allow to warm up object and list (mtarld)
 * feature #59565 [Console] Deprecating Command getDefaultName and getDefaultDescription methods (yceruto)
 * feature #59473 [Console] Add broader support for command "help" definition (yceruto)
 * feature #54744 [Validator] deprecate the use of option arrays to configure validation constraints (xabbuh)
 * feature #59493 [Console] Invokable command adjustments (yceruto)
 * feature #59482 [Mailer] [Smtp] Add DSN option to make SocketStream bind to IPv4 (quilius)
 * feature #57721 [Security][SecurityBundle] Add encryption support to OIDC tokens (Spomky)
 * feature #58599 [Serializer] Add xml context option to ignore empty attributes (qdequippe)
 * feature #59368 [TypeInfo] Add `TypeFactoryTrait::fromValue` method (mtarld)
 * feature #59401 [JsonEncoder] Add `JsonEncodable` attribute (mtarld)
 * feature #59123 [WebProfilerBundle] Extend web profiler listener & config for replace on ajax requests (chr-hertel)
 * feature #59477 [Mailer][Notifier] Add and use `Dsn::getBooleanOption()` (OskarStark)
 * feature #59474 [Console] Invokable command deprecations (yceruto)
 * feature #59340 [Console] Add support for invokable commands and input attributes (yceruto)
 * feature #59035 [VarDumper] Add casters for object-converted resources (alexandre-daubois)
 * feature #59225 [FrameworkBundle] Always display service arguments & deprecate `--show-arguments` option for `debug:container` (Florian-Merle)
 * feature #59384 [PhpUnitBridge] Enable configuring mock namespaces with attributes (HypeMC)
 * feature #59370 [HttpClient] Allow using HTTP/3 with the `CurlHttpClient` (MatTheCat)
 * feature #50334 [FrameworkBundle][PropertyInfo] Wire the `ConstructorExtractor` class (HypeMC)
 * feature #59354 [OptionsResolver] Support union of types (VincentLanglet)
 * feature #58542 [Validator] Add `Slug` constraint (raffaelecarelle)
 * feature #59286 [Serializer] Deprecate the `CompiledClassMetadataFactory` (mtarld)
 * feature #59257 [DependencyInjection] Support `@>` as a shorthand for `!service_closure` in YamlFileLoader (chx)
 * feature #58545 [String] Add `AbstractString::pascal()` method (raffaelecarelle)
 * feature #58559 [Validator] [DateTime] Add `format` to error messages (sauliusnord)
 * feature #58564 [HttpKernel] Let Monolog handle the creation of log folder for improved readonly containers handling (shyim)
 * feature #59360 [Messenger] Implement `KeepaliveReceiverInterface` in Redis bridge (HypeMC)
 * feature #58698 [Mailer] Add AhaSend Bridge (farhadhf)
 * feature #57632 [PropertyInfo] Add `PropertyDescriptionExtractorInterface` to `PhpStanExtractor` (mtarld)
 * feature #58786 [Notifier] [Brevo][SMS] Brevo sms notifier add options (ikerib)
 * feature #59273 [Messenger] Add `BeanstalkdPriorityStamp` to Beanstalkd bridge (HypeMC)
 * feature #58761 [Mailer] [Amazon] Add support for custom headers in ses+api (StudioMaX)
 * feature #54939 [Mailer] Add `retry_period` option for email transport (Sébastien Despont, fabpot)
 * feature #59068 [HttpClient] Add IPv6 support to NativeHttpClient (dmitrii-baranov-tg)
 * feature #59088 [DependencyInjection] Make `#[AsTaggedItem]` repeatable (alexandre-daubois)
 * feature #59301 [Cache][HttpKernel] Add a `noStore` argument to the `#` attribute (smnandre)
 * feature #59315 [Yaml] Add compact nested mapping support to `Dumper` (gr8b)
 * feature #59325 [Config] Add `ifFalse()` (OskarStark)
 * feature #58243 [Yaml] Add support for dumping `null` as an empty value by using the `Yaml::DUMP_NULL_AS_EMPTY` flag (alexandre-daubois)
 * feature #59291 [TypeInfo] Add `accepts` method (mtarld)
 * feature #59265 [Validator] Validate SVG ratio in Image validator (maximecolin)
 * feature #59129 [SecurityBundle][TwigBridge] Add `is_granted_for_user()` function  (natewiebe13)
 * feature #59254 [JsonEncoder] Remove chunk size definition (mtarld)
 * feature #59022 [HttpFoundation] Generate url-safe hashes for signed urls (valtzu)
 * feature #59177 [JsonEncoder] Add native lazyghost support (mtarld)
 * feature #59192 [PropertyInfo] Add non-*-int missing types for PhpStanExtractor (wuchen90)
 * feature #58515 [FrameworkBundle][JsonEncoder] Wire services (mtarld)
 * feature #59157 [HttpKernel] [MapQueryString] added key argument to MapQueryString attribute (feymo)
 * feature #59154 [HttpFoundation] Support iterable of string in `StreamedResponse` (mtarld)
 * feature #51718 [Serializer] [JsonEncoder] Introducing the component (mtarld)
 * feature #58946 [Console] Add support of millisecondes for `formatTime` (SebLevDev)
 * feature #48142 [Security][SecurityBundle] User authorization checker (natewiebe13)
 * feature #59075 [Uid] Add ``@return` non-empty-string` annotations to `AbstractUid` and relevant functions (niravpateljoin)
 * feature #59114 [ErrorHandler] support non-empty-string/non-empty-list when patching return types (xabbuh)
 * feature #59020 [AssetMapper] add support for assets pre-compression (dunglas)
 * feature #58651 [Mailer][Notifier] Add webhooks signature verification on Sweego bridges (welcoMattic)
 * feature #59026 [VarDumper] Add caster for Socket instances (nicolas-grekas)
 * feature #58989 [VarDumper] Add caster for `AddressInfo` objects (nicolas-grekas)

