# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.dnsresolver import DnsResolverManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDnsResolverManagementForwardingRulesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DnsResolverManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_forwarding_rules_get(self, resource_group):
        response = self.client.forwarding_rules.get(
            resource_group_name=resource_group.name,
            dns_forwarding_ruleset_name="str",
            forwarding_rule_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_forwarding_rules_create_or_update(self, resource_group):
        response = self.client.forwarding_rules.create_or_update(
            resource_group_name=resource_group.name,
            dns_forwarding_ruleset_name="str",
            forwarding_rule_name="str",
            parameters={
                "properties": {
                    "domainName": "str",
                    "targetDnsServers": [{"ipAddress": "str", "port": 0}],
                    "forwardingRuleState": "str",
                    "metadata": {"str": "str"},
                    "provisioningState": "str",
                },
                "etag": "str",
                "id": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_forwarding_rules_update(self, resource_group):
        response = self.client.forwarding_rules.update(
            resource_group_name=resource_group.name,
            dns_forwarding_ruleset_name="str",
            forwarding_rule_name="str",
            parameters={
                "properties": {
                    "forwardingRuleState": "str",
                    "metadata": {"str": "str"},
                    "targetDnsServers": [{"ipAddress": "str", "port": 0}],
                }
            },
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_forwarding_rules_delete(self, resource_group):
        response = self.client.forwarding_rules.delete(
            resource_group_name=resource_group.name,
            dns_forwarding_ruleset_name="str",
            forwarding_rule_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_forwarding_rules_list(self, resource_group):
        response = self.client.forwarding_rules.list(
            resource_group_name=resource_group.name,
            dns_forwarding_ruleset_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
