//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsupport

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// TicketCommunicationsNoSubscriptionClient contains the methods for the SupportTicketCommunicationsNoSubscription group.
// Don't use this type directly, use NewTicketCommunicationsNoSubscriptionClient() instead.
type TicketCommunicationsNoSubscriptionClient struct {
	internal *arm.Client
}

// NewTicketCommunicationsNoSubscriptionClient creates a new instance of TicketCommunicationsNoSubscriptionClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewTicketCommunicationsNoSubscriptionClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*TicketCommunicationsNoSubscriptionClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &TicketCommunicationsNoSubscriptionClient{
		internal: cl,
	}
	return client, nil
}

// NewListPager - Lists all communications (attachments not included) for a support ticket.
// You can also filter support ticket communications by CreatedDate or CommunicationType using the $filter parameter. The
// only type of communication supported today is Web. Output will be a paged result
// with nextLink, using which you can retrieve the next set of Communication results.
// Support ticket data is available for 18 months after ticket creation. If a ticket was created more than 18 months ago,
// a request for data might cause an error.
//
// Generated from API version 2022-09-01-preview
//   - supportTicketName - Support ticket name
//   - options - TicketCommunicationsNoSubscriptionClientListOptions contains the optional parameters for the TicketCommunicationsNoSubscriptionClient.NewListPager
//     method.
func (client *TicketCommunicationsNoSubscriptionClient) NewListPager(supportTicketName string, options *TicketCommunicationsNoSubscriptionClientListOptions) *runtime.Pager[TicketCommunicationsNoSubscriptionClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[TicketCommunicationsNoSubscriptionClientListResponse]{
		More: func(page TicketCommunicationsNoSubscriptionClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *TicketCommunicationsNoSubscriptionClientListResponse) (TicketCommunicationsNoSubscriptionClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "TicketCommunicationsNoSubscriptionClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, supportTicketName, options)
			}, nil)
			if err != nil {
				return TicketCommunicationsNoSubscriptionClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *TicketCommunicationsNoSubscriptionClient) listCreateRequest(ctx context.Context, supportTicketName string, options *TicketCommunicationsNoSubscriptionClientListOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Support/supportTickets/{supportTicketName}/communications"
	if supportTicketName == "" {
		return nil, errors.New("parameter supportTicketName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{supportTicketName}", url.PathEscape(supportTicketName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	reqQP.Set("api-version", "2022-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *TicketCommunicationsNoSubscriptionClient) listHandleResponse(resp *http.Response) (TicketCommunicationsNoSubscriptionClientListResponse, error) {
	result := TicketCommunicationsNoSubscriptionClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CommunicationsListResult); err != nil {
		return TicketCommunicationsNoSubscriptionClientListResponse{}, err
	}
	return result, nil
}
