//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mediaservices/armmediaservices/v3"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// LiveEventsServer is a fake server for instances of the armmediaservices.LiveEventsClient type.
type LiveEventsServer struct {
	// BeginAllocate is the fake for method LiveEventsClient.BeginAllocate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginAllocate func(ctx context.Context, resourceGroupName string, accountName string, liveEventName string, options *armmediaservices.LiveEventsClientBeginAllocateOptions) (resp azfake.PollerResponder[armmediaservices.LiveEventsClientAllocateResponse], errResp azfake.ErrorResponder)

	// AsyncOperation is the fake for method LiveEventsClient.AsyncOperation
	// HTTP status codes to indicate success: http.StatusOK
	AsyncOperation func(ctx context.Context, resourceGroupName string, accountName string, operationID string, options *armmediaservices.LiveEventsClientAsyncOperationOptions) (resp azfake.Responder[armmediaservices.LiveEventsClientAsyncOperationResponse], errResp azfake.ErrorResponder)

	// BeginCreate is the fake for method LiveEventsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, accountName string, liveEventName string, parameters armmediaservices.LiveEvent, options *armmediaservices.LiveEventsClientBeginCreateOptions) (resp azfake.PollerResponder[armmediaservices.LiveEventsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method LiveEventsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, accountName string, liveEventName string, options *armmediaservices.LiveEventsClientBeginDeleteOptions) (resp azfake.PollerResponder[armmediaservices.LiveEventsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method LiveEventsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, liveEventName string, options *armmediaservices.LiveEventsClientGetOptions) (resp azfake.Responder[armmediaservices.LiveEventsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method LiveEventsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, accountName string, options *armmediaservices.LiveEventsClientListOptions) (resp azfake.PagerResponder[armmediaservices.LiveEventsClientListResponse])

	// OperationLocation is the fake for method LiveEventsClient.OperationLocation
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	OperationLocation func(ctx context.Context, resourceGroupName string, accountName string, liveEventName string, operationID string, options *armmediaservices.LiveEventsClientOperationLocationOptions) (resp azfake.Responder[armmediaservices.LiveEventsClientOperationLocationResponse], errResp azfake.ErrorResponder)

	// BeginReset is the fake for method LiveEventsClient.BeginReset
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginReset func(ctx context.Context, resourceGroupName string, accountName string, liveEventName string, options *armmediaservices.LiveEventsClientBeginResetOptions) (resp azfake.PollerResponder[armmediaservices.LiveEventsClientResetResponse], errResp azfake.ErrorResponder)

	// BeginStart is the fake for method LiveEventsClient.BeginStart
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStart func(ctx context.Context, resourceGroupName string, accountName string, liveEventName string, options *armmediaservices.LiveEventsClientBeginStartOptions) (resp azfake.PollerResponder[armmediaservices.LiveEventsClientStartResponse], errResp azfake.ErrorResponder)

	// BeginStop is the fake for method LiveEventsClient.BeginStop
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStop func(ctx context.Context, resourceGroupName string, accountName string, liveEventName string, parameters armmediaservices.LiveEventActionInput, options *armmediaservices.LiveEventsClientBeginStopOptions) (resp azfake.PollerResponder[armmediaservices.LiveEventsClientStopResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method LiveEventsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, accountName string, liveEventName string, parameters armmediaservices.LiveEvent, options *armmediaservices.LiveEventsClientBeginUpdateOptions) (resp azfake.PollerResponder[armmediaservices.LiveEventsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewLiveEventsServerTransport creates a new instance of LiveEventsServerTransport with the provided implementation.
// The returned LiveEventsServerTransport instance is connected to an instance of armmediaservices.LiveEventsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLiveEventsServerTransport(srv *LiveEventsServer) *LiveEventsServerTransport {
	return &LiveEventsServerTransport{
		srv:           srv,
		beginAllocate: newTracker[azfake.PollerResponder[armmediaservices.LiveEventsClientAllocateResponse]](),
		beginCreate:   newTracker[azfake.PollerResponder[armmediaservices.LiveEventsClientCreateResponse]](),
		beginDelete:   newTracker[azfake.PollerResponder[armmediaservices.LiveEventsClientDeleteResponse]](),
		newListPager:  newTracker[azfake.PagerResponder[armmediaservices.LiveEventsClientListResponse]](),
		beginReset:    newTracker[azfake.PollerResponder[armmediaservices.LiveEventsClientResetResponse]](),
		beginStart:    newTracker[azfake.PollerResponder[armmediaservices.LiveEventsClientStartResponse]](),
		beginStop:     newTracker[azfake.PollerResponder[armmediaservices.LiveEventsClientStopResponse]](),
		beginUpdate:   newTracker[azfake.PollerResponder[armmediaservices.LiveEventsClientUpdateResponse]](),
	}
}

// LiveEventsServerTransport connects instances of armmediaservices.LiveEventsClient to instances of LiveEventsServer.
// Don't use this type directly, use NewLiveEventsServerTransport instead.
type LiveEventsServerTransport struct {
	srv           *LiveEventsServer
	beginAllocate *tracker[azfake.PollerResponder[armmediaservices.LiveEventsClientAllocateResponse]]
	beginCreate   *tracker[azfake.PollerResponder[armmediaservices.LiveEventsClientCreateResponse]]
	beginDelete   *tracker[azfake.PollerResponder[armmediaservices.LiveEventsClientDeleteResponse]]
	newListPager  *tracker[azfake.PagerResponder[armmediaservices.LiveEventsClientListResponse]]
	beginReset    *tracker[azfake.PollerResponder[armmediaservices.LiveEventsClientResetResponse]]
	beginStart    *tracker[azfake.PollerResponder[armmediaservices.LiveEventsClientStartResponse]]
	beginStop     *tracker[azfake.PollerResponder[armmediaservices.LiveEventsClientStopResponse]]
	beginUpdate   *tracker[azfake.PollerResponder[armmediaservices.LiveEventsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for LiveEventsServerTransport.
func (l *LiveEventsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LiveEventsClient.BeginAllocate":
		resp, err = l.dispatchBeginAllocate(req)
	case "LiveEventsClient.AsyncOperation":
		resp, err = l.dispatchAsyncOperation(req)
	case "LiveEventsClient.BeginCreate":
		resp, err = l.dispatchBeginCreate(req)
	case "LiveEventsClient.BeginDelete":
		resp, err = l.dispatchBeginDelete(req)
	case "LiveEventsClient.Get":
		resp, err = l.dispatchGet(req)
	case "LiveEventsClient.NewListPager":
		resp, err = l.dispatchNewListPager(req)
	case "LiveEventsClient.OperationLocation":
		resp, err = l.dispatchOperationLocation(req)
	case "LiveEventsClient.BeginReset":
		resp, err = l.dispatchBeginReset(req)
	case "LiveEventsClient.BeginStart":
		resp, err = l.dispatchBeginStart(req)
	case "LiveEventsClient.BeginStop":
		resp, err = l.dispatchBeginStop(req)
	case "LiveEventsClient.BeginUpdate":
		resp, err = l.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LiveEventsServerTransport) dispatchBeginAllocate(req *http.Request) (*http.Response, error) {
	if l.srv.BeginAllocate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginAllocate not implemented")}
	}
	beginAllocate := l.beginAllocate.get(req)
	if beginAllocate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveEvents/(?P<liveEventName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/allocate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		liveEventNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveEventName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginAllocate(req.Context(), resourceGroupNameParam, accountNameParam, liveEventNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginAllocate = &respr
		l.beginAllocate.add(req, beginAllocate)
	}

	resp, err := server.PollerResponderNext(beginAllocate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginAllocate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginAllocate) {
		l.beginAllocate.remove(req)
	}

	return resp, nil
}

func (l *LiveEventsServerTransport) dispatchAsyncOperation(req *http.Request) (*http.Response, error) {
	if l.srv.AsyncOperation == nil {
		return nil, &nonRetriableError{errors.New("fake for method AsyncOperation not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveEventOperations/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.AsyncOperation(req.Context(), resourceGroupNameParam, accountNameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AsyncOperationResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LiveEventsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if l.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := l.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveEvents/(?P<liveEventName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		body, err := server.UnmarshalRequestAsJSON[armmediaservices.LiveEvent](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		liveEventNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveEventName")])
		if err != nil {
			return nil, err
		}
		autoStartUnescaped, err := url.QueryUnescape(qp.Get("autoStart"))
		if err != nil {
			return nil, err
		}
		autoStartParam, err := parseOptional(autoStartUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armmediaservices.LiveEventsClientBeginCreateOptions
		if autoStartParam != nil {
			options = &armmediaservices.LiveEventsClientBeginCreateOptions{
				AutoStart: autoStartParam,
			}
		}
		respr, errRespr := l.srv.BeginCreate(req.Context(), resourceGroupNameParam, accountNameParam, liveEventNameParam, body, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		l.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		l.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		l.beginCreate.remove(req)
	}

	return resp, nil
}

func (l *LiveEventsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if l.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := l.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveEvents/(?P<liveEventName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		liveEventNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveEventName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginDelete(req.Context(), resourceGroupNameParam, accountNameParam, liveEventNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		l.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		l.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		l.beginDelete.remove(req)
	}

	return resp, nil
}

func (l *LiveEventsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if l.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveEvents/(?P<liveEventName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	liveEventNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveEventName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, liveEventNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LiveEvent, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LiveEventsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := l.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveEvents`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		resp := l.srv.NewListPager(resourceGroupNameParam, accountNameParam, nil)
		newListPager = &resp
		l.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armmediaservices.LiveEventsClientListResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		l.newListPager.remove(req)
	}
	return resp, nil
}

func (l *LiveEventsServerTransport) dispatchOperationLocation(req *http.Request) (*http.Response, error) {
	if l.srv.OperationLocation == nil {
		return nil, &nonRetriableError{errors.New("fake for method OperationLocation not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveEvents/(?P<liveEventName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operationLocations/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	liveEventNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveEventName")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.OperationLocation(req.Context(), resourceGroupNameParam, accountNameParam, liveEventNameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LiveEvent, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LiveEventsServerTransport) dispatchBeginReset(req *http.Request) (*http.Response, error) {
	if l.srv.BeginReset == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginReset not implemented")}
	}
	beginReset := l.beginReset.get(req)
	if beginReset == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveEvents/(?P<liveEventName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reset`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		liveEventNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveEventName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginReset(req.Context(), resourceGroupNameParam, accountNameParam, liveEventNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginReset = &respr
		l.beginReset.add(req, beginReset)
	}

	resp, err := server.PollerResponderNext(beginReset, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginReset.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginReset) {
		l.beginReset.remove(req)
	}

	return resp, nil
}

func (l *LiveEventsServerTransport) dispatchBeginStart(req *http.Request) (*http.Response, error) {
	if l.srv.BeginStart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStart not implemented")}
	}
	beginStart := l.beginStart.get(req)
	if beginStart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveEvents/(?P<liveEventName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		liveEventNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveEventName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginStart(req.Context(), resourceGroupNameParam, accountNameParam, liveEventNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStart = &respr
		l.beginStart.add(req, beginStart)
	}

	resp, err := server.PollerResponderNext(beginStart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginStart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStart) {
		l.beginStart.remove(req)
	}

	return resp, nil
}

func (l *LiveEventsServerTransport) dispatchBeginStop(req *http.Request) (*http.Response, error) {
	if l.srv.BeginStop == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStop not implemented")}
	}
	beginStop := l.beginStop.get(req)
	if beginStop == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveEvents/(?P<liveEventName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmediaservices.LiveEventActionInput](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		liveEventNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveEventName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginStop(req.Context(), resourceGroupNameParam, accountNameParam, liveEventNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStop = &respr
		l.beginStop.add(req, beginStop)
	}

	resp, err := server.PollerResponderNext(beginStop, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginStop.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStop) {
		l.beginStop.remove(req)
	}

	return resp, nil
}

func (l *LiveEventsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if l.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := l.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveEvents/(?P<liveEventName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmediaservices.LiveEvent](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		liveEventNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveEventName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginUpdate(req.Context(), resourceGroupNameParam, accountNameParam, liveEventNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		l.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		l.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		l.beginUpdate.remove(req)
	}

	return resp, nil
}
