//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbotservice

import "time"

// AcsChatChannel - AcsChat channel definition
type AcsChatChannel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type AcsChatChannel.
func (a *AcsChatChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       a.ChannelName,
		Etag:              a.Etag,
		Location:          a.Location,
		ProvisioningState: a.ProvisioningState,
	}
}

// AlexaChannel - Alexa channel definition
type AlexaChannel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to Alexa channel resource
	Properties *AlexaChannelProperties

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type AlexaChannel.
func (a *AlexaChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       a.ChannelName,
		Etag:              a.Etag,
		Location:          a.Location,
		ProvisioningState: a.ProvisioningState,
	}
}

// AlexaChannelProperties - The parameters to provide for the Alexa channel.
type AlexaChannelProperties struct {
	// REQUIRED; The Alexa skill Id
	AlexaSkillID *string

	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool

	// READ-ONLY; Full Uri used to configured the skill in Alexa
	ServiceEndpointURI *string

	// READ-ONLY; Url fragment used in part of the Uri configured in Alexa
	URLFragment *string
}

// Bot resource definition
type Bot struct {
	// Entity Tag
	Etag *string

	// Required. Gets or sets the Kind of the resource.
	Kind *Kind

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to bot resource
	Properties *BotProperties

	// Gets or sets the SKU of the resource.
	SKU *SKU

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string

	// READ-ONLY; Specifies the resource ID.
	ID *string

	// READ-ONLY; Specifies the name of the resource.
	Name *string

	// READ-ONLY; Specifies the type of the resource.
	Type *string

	// READ-ONLY; Entity zones
	Zones []*string
}

// BotChannel - Bot channel resource definition
type BotChannel struct {
	// Entity Tag
	Etag *string

	// Required. Gets or sets the Kind of the resource.
	Kind *Kind

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to bot channel resource
	Properties ChannelClassification

	// Gets or sets the SKU of the resource.
	SKU *SKU

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string

	// READ-ONLY; Specifies the resource ID.
	ID *string

	// READ-ONLY; Specifies the name of the resource.
	Name *string

	// READ-ONLY; Specifies the type of the resource.
	Type *string

	// READ-ONLY; Entity zones
	Zones []*string
}

// BotProperties - The parameters to provide for the Bot.
type BotProperties struct {
	// REQUIRED; The Name of the bot
	DisplayName *string

	// REQUIRED; The bot's endpoint
	Endpoint *string

	// REQUIRED; Microsoft App Id for the bot
	MsaAppID *string

	// Contains resource all settings defined as key/value pairs.
	AllSettings map[string]*string

	// The hint (e.g. keyVault secret resourceId) on how to fetch the app secret
	AppPasswordHint *string

	// The CMK Url
	CmekKeyVaultURL *string

	// The description of the bot
	Description *string

	// The Application Insights key
	DeveloperAppInsightKey *string

	// The Application Insights Api Key
	DeveloperAppInsightsAPIKey *string

	// The Application Insights App Id
	DeveloperAppInsightsApplicationID *string

	// Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
	DisableLocalAuth *bool

	// The Icon Url of the bot
	IconURL *string

	// Whether Cmek is enabled
	IsCmekEnabled *bool

	// Whether the bot is streaming supported
	IsStreamingSupported *bool

	// Collection of LUIS App Ids
	LuisAppIDs []*string

	// The LUIS Key
	LuisKey *string

	// The bot's manifest url
	ManifestURL *string

	// Microsoft App Managed Identity Resource Id for the bot
	MsaAppMSIResourceID *string

	// Microsoft App Tenant Id for the bot
	MsaAppTenantID *string

	// Microsoft App Type for the bot
	MsaAppType *MsaAppType

	// The hint to browser (e.g. protocol handler) on how to open the bot for authoring
	OpenWithHint *string

	// Contains resource parameters defined as key/value pairs.
	Parameters map[string]*string

	// Whether the bot is in an isolated network
	PublicNetworkAccess *PublicNetworkAccess

	// Publishing credentials of the resource
	PublishingCredentials *string

	// The channel schema transformation version for the bot
	SchemaTransformationVersion *string

	// The storage resourceId for the bot
	StorageResourceID *string

	// The Tenant Id for the bot
	TenantID *string

	// READ-ONLY; The CMK encryption status
	CmekEncryptionStatus *string

	// READ-ONLY; Collection of channels for which the bot is configured
	ConfiguredChannels []*string

	// READ-ONLY; Collection of channels for which the bot is enabled
	EnabledChannels []*string

	// READ-ONLY; The bot's endpoint version
	EndpointVersion *string

	// READ-ONLY; Whether the bot is developerAppInsightsApiKey set
	IsDeveloperAppInsightsAPIKeySet *bool

	// READ-ONLY; Token used to migrate non Azure bot to azure subscription
	MigrationToken *string

	// READ-ONLY; List of Private Endpoint Connections configured for the bot
	PrivateEndpointConnections []*PrivateEndpointConnection

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// BotResponseList - The list of bot service operation response.
type BotResponseList struct {
	// The link used to get the next page of bot service resources.
	NextLink *string

	// READ-ONLY; Gets the list of bot service results and their properties.
	Value []*Bot
}

// Channel definition
type Channel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type Channel.
func (c *Channel) GetChannel() *Channel { return c }

// ChannelResponseList - The list of bot service channel operation response.
type ChannelResponseList struct {
	// The link used to get the next page of bot service channel resources.
	NextLink *string

	// READ-ONLY; Gets the list of bot service channel results and their properties.
	Value []*BotChannel
}

// ChannelSettings - Channel settings definition
type ChannelSettings struct {
	// The bot id
	BotID *string

	// The bot icon url
	BotIconURL *string

	// The channel display name
	ChannelDisplayName *string

	// The channel id
	ChannelID *string

	// Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication.
	DisableLocalAuth *bool

	// The extensionKey1
	ExtensionKey1 *string

	// The extensionKey2
	ExtensionKey2 *string

	// Whether this channel is enabled for the bot
	IsEnabled *bool

	// Whether customer needs to agree to new terms.
	RequireTermsAgreement *bool

	// The list of sites
	Sites []*Site
}

// CheckNameAvailabilityRequestBody - The request body for a request to Bot Service Management to check availability of a
// bot name.
type CheckNameAvailabilityRequestBody struct {
	// the name of the bot for which availability needs to be checked.
	Name *string

	// the type of the bot for which availability needs to be checked
	Type *string
}

// CheckNameAvailabilityResponseBody - The response body returned for a request to Bot Service Management to check availability
// of a bot name.
type CheckNameAvailabilityResponseBody struct {
	// response code from ABS
	AbsCode *string

	// additional message from the bot management api showing why a bot name is not available
	Message *string

	// indicates if the bot name is valid.
	Valid *bool
}

// ConnectionItemName - The display name of a connection Item Setting registered with the Bot
type ConnectionItemName struct {
	// READ-ONLY; Connection Item name that has been added in the API
	Name *string
}

// ConnectionSetting - Bot channel resource definition
type ConnectionSetting struct {
	// Entity Tag
	Etag *string

	// Required. Gets or sets the Kind of the resource.
	Kind *Kind

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to bot channel resource
	Properties *ConnectionSettingProperties

	// Gets or sets the SKU of the resource.
	SKU *SKU

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string

	// READ-ONLY; Specifies the resource ID.
	ID *string

	// READ-ONLY; Specifies the name of the resource.
	Name *string

	// READ-ONLY; Specifies the type of the resource.
	Type *string

	// READ-ONLY; Entity zones
	Zones []*string
}

// ConnectionSettingParameter - Extra Parameter in a Connection Setting Properties to indicate service provider specific properties
type ConnectionSettingParameter struct {
	// Key for the Connection Setting Parameter.
	Key *string

	// Value associated with the Connection Setting Parameter.
	Value *string
}

// ConnectionSettingProperties - Properties for a Connection Setting Item
type ConnectionSettingProperties struct {
	// Client Id associated with the Connection Setting.
	ClientID *string

	// Client Secret associated with the Connection Setting
	ClientSecret *string

	// Service Provider Parameters associated with the Connection Setting
	Parameters []*ConnectionSettingParameter

	// Provisioning state of the resource
	ProvisioningState *string

	// Scopes associated with the Connection Setting
	Scopes *string

	// Service Provider Display Name associated with the Connection Setting
	ServiceProviderDisplayName *string

	// Service Provider Id associated with the Connection Setting
	ServiceProviderID *string

	// READ-ONLY; Setting Id set by the service for the Connection Setting.
	SettingID *string
}

// ConnectionSettingResponseList - The list of bot service connection settings response.
type ConnectionSettingResponseList struct {
	// The link used to get the next page of bot service connection setting resources.
	NextLink *string

	// READ-ONLY; Gets the list of bot service connection settings and their properties.
	Value []*ConnectionSetting
}

// CreateEmailSignInURLResponse - The ARM create email sign in url operation response.
type CreateEmailSignInURLResponse struct {
	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to sign in url
	Properties *CreateEmailSignInURLResponseProperties

	// READ-ONLY; Specifies the resource ID.
	ID *string
}

// CreateEmailSignInURLResponseProperties - The set of properties specific to sign in url
type CreateEmailSignInURLResponseProperties struct {
	// Sign in url.
	URL *string
}

// DirectLineChannel - Direct Line channel definition
type DirectLineChannel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to Direct Line channel resource
	Properties *DirectLineChannelProperties

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type DirectLineChannel.
func (d *DirectLineChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       d.ChannelName,
		Etag:              d.Etag,
		Location:          d.Location,
		ProvisioningState: d.ProvisioningState,
	}
}

// DirectLineChannelProperties - The parameters to provide for the Direct Line channel.
type DirectLineChannelProperties struct {
	// Direct Line embed code of the resource
	DirectLineEmbedCode *string

	// The extensionKey1
	ExtensionKey1 *string

	// The extensionKey2
	ExtensionKey2 *string

	// The list of Direct Line sites
	Sites []*DirectLineSite
}

// DirectLineSite - A site for the Direct Line channel
type DirectLineSite struct {
	// REQUIRED; Whether this site is enabled for DirectLine channel
	IsEnabled *bool

	// REQUIRED; Site name
	SiteName *string

	// DirectLine application id
	AppID *string

	// Entity Tag
	ETag *string

	// Whether this site is enabled for block user upload.
	IsBlockUserUploadEnabled *bool

	// Whether this site is disabled detailed logging for
	IsDetailedLoggingEnabled *bool

	// Whether this site is EndpointParameters enabled for channel
	IsEndpointParametersEnabled *bool

	// Whether this no-storage site is disabled detailed logging for
	IsNoStorageEnabled *bool

	// Whether this site is enabled for authentication with Bot Framework.
	IsSecureSiteEnabled *bool

	// Whether this site is enabled for Bot Framework V1 protocol.
	IsV1Enabled *bool

	// Whether this site is enabled for Bot Framework V3 protocol.
	IsV3Enabled *bool

	// Whether this site is enabled for Webchat Speech
	IsWebChatSpeechEnabled *bool

	// Whether this site is enabled for preview versions of Webchat
	IsWebchatPreviewEnabled *bool

	// Tenant Id
	TenantID *string

	// List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
	TrustedOrigins []*string

	// READ-ONLY; Whether this site is token enabled for channel
	IsTokenEnabled *bool

	// READ-ONLY; Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key *string

	// READ-ONLY; Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key2 *string

	// READ-ONLY; Site Id
	SiteID *string
}

// DirectLineSpeechChannel - DirectLine Speech channel definition
type DirectLineSpeechChannel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to DirectLine Speech channel resource
	Properties *DirectLineSpeechChannelProperties

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type DirectLineSpeechChannel.
func (d *DirectLineSpeechChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       d.ChannelName,
		Etag:              d.Etag,
		Location:          d.Location,
		ProvisioningState: d.ProvisioningState,
	}
}

// DirectLineSpeechChannelProperties - The parameters to provide for the DirectLine Speech channel.
type DirectLineSpeechChannelProperties struct {
	// The cognitive service region with this channel registration.
	CognitiveServiceRegion *string

	// The cognitive service id with this channel registration.
	CognitiveServiceResourceID *string

	// The cognitive service subscription key to use with this channel registration.
	CognitiveServiceSubscriptionKey *string

	// Custom voice deployment id (optional).
	CustomSpeechModelID *string

	// Custom speech model id (optional).
	CustomVoiceDeploymentID *string

	// Make this a default bot for chosen cognitive service account.
	IsDefaultBotForCogSvcAccount *bool

	// Whether this channel is enabled or not.
	IsEnabled *bool
}

// EmailChannel - Email channel definition
type EmailChannel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to email channel resource
	Properties *EmailChannelProperties

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type EmailChannel.
func (e *EmailChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       e.ChannelName,
		Etag:              e.Etag,
		Location:          e.Location,
		ProvisioningState: e.ProvisioningState,
	}
}

// EmailChannelProperties - The parameters to provide for the Email channel.
type EmailChannelProperties struct {
	// REQUIRED; The email address
	EmailAddress *string

	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool

	// Email channel auth method. 0 Password (Default); 1 Graph.
	AuthMethod *EmailChannelAuthMethod

	// The magic code for setting up the modern authentication.
	MagicCode *string

	// The password for the email address. Value only returned through POST to the action Channel List API, otherwise empty.
	Password *string
}

// Error - Bot Service error object.
type Error struct {
	// The error body.
	Error *ErrorBody
}

// ErrorBody - Bot Service error body.
type ErrorBody struct {
	// REQUIRED; error code
	Code *string

	// REQUIRED; error message
	Message *string
}

// FacebookChannel - Facebook channel definition
type FacebookChannel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to bot facebook channel
	Properties *FacebookChannelProperties

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type FacebookChannel.
func (f *FacebookChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       f.ChannelName,
		Etag:              f.Etag,
		Location:          f.Location,
		ProvisioningState: f.ProvisioningState,
	}
}

// FacebookChannelProperties - The parameters to provide for the Facebook channel.
type FacebookChannelProperties struct {
	// REQUIRED; Facebook application id
	AppID *string

	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool

	// Facebook application secret. Value only returned through POST to the action Channel List API, otherwise empty.
	AppSecret *string

	// The list of Facebook pages
	Pages []*FacebookPage

	// READ-ONLY; Callback Url
	CallbackURL *string

	// READ-ONLY; Verify token. Value only returned through POST to the action Channel List API, otherwise empty.
	VerifyToken *string
}

// FacebookPage - A Facebook page for Facebook channel registration
type FacebookPage struct {
	// REQUIRED; Page id
	ID *string

	// Facebook application access token. Value only returned through POST to the action Channel List API, otherwise empty.
	AccessToken *string
}

// HostSettingsResponse - The response body returned for a request to Bot Service Management to check per subscription hostSettings
type HostSettingsResponse struct {
	// Same as toBotFromChannelOpenIdMetadataUrl, used by SDK < v4.12
	BotOpenIDMetadata *string

	// For in-conversation bot user authentication
	OAuthURL *string

	// For verifying incoming tokens from the channels
	ToBotFromChannelOpenIDMetadataURL *string

	// For verifying incoming tokens from the channels
	ToBotFromChannelTokenIssuer *string

	// For verifying incoming tokens from bot emulator
	ToBotFromEmulatorOpenIDMetadataURL *string

	// For getting access token to channels from bot host
	ToChannelFromBotLoginURL *string

	// For getting access token to channels from bot host
	ToChannelFromBotOAuthScope *string

	// Per cloud OAuth setting on whether authority is validated
	ValidateAuthority *bool
}

// KikChannel - Kik channel definition
type KikChannel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to Kik channel resource
	Properties *KikChannelProperties

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type KikChannel.
func (k *KikChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       k.ChannelName,
		Etag:              k.Etag,
		Location:          k.Location,
		ProvisioningState: k.ProvisioningState,
	}
}

// KikChannelProperties - The parameters to provide for the Kik channel.
type KikChannelProperties struct {
	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool

	// REQUIRED; The Kik user name
	UserName *string

	// Kik API key. Value only returned through POST to the action Channel List API, otherwise empty.
	APIKey *string

	// Whether this channel is validated for the bot
	IsValidated *bool
}

// LineChannel - Line channel definition
type LineChannel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to line channel resource
	Properties *LineChannelProperties

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type LineChannel.
func (l *LineChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       l.ChannelName,
		Etag:              l.Etag,
		Location:          l.Location,
		ProvisioningState: l.ProvisioningState,
	}
}

// LineChannelProperties - The parameters to provide for the Line channel.
type LineChannelProperties struct {
	// REQUIRED; The list of line channel registrations
	LineRegistrations []*LineRegistration

	// READ-ONLY; Callback Url to enter in line registration.
	CallbackURL *string

	// READ-ONLY; Whether this channel is validated for the bot
	IsValidated *bool
}

// LineRegistration - The properties corresponding to a line channel registration
type LineRegistration struct {
	// Access token for the line channel registration
	ChannelAccessToken *string

	// Secret for the line channel registration
	ChannelSecret *string

	// READ-ONLY; Id generated for the line channel registration
	GeneratedID *string
}

// ListChannelWithKeysResponse - The ARM channel of list channel with keys operation response.
type ListChannelWithKeysResponse struct {
	// Changed time of the resource
	ChangedTime *string

	// Entity tag of the resource
	EntityTag *string

	// Entity Tag
	Etag *string

	// Required. Gets or sets the Kind of the resource.
	Kind *Kind

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to bot channel resource
	Properties ChannelClassification

	// Provisioning state of the resource
	ProvisioningState *string

	// The set of properties specific to bot channel resource
	Resource ChannelClassification

	// Gets or sets the SKU of the resource.
	SKU *SKU

	// Channel settings
	Setting *ChannelSettings

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string

	// READ-ONLY; Specifies the resource ID.
	ID *string

	// READ-ONLY; Specifies the name of the resource.
	Name *string

	// READ-ONLY; Specifies the type of the resource.
	Type *string

	// READ-ONLY; Entity zones
	Zones []*string
}

// M365Extensions - M365 Extensions definition
type M365Extensions struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type M365Extensions.
func (m *M365Extensions) GetChannel() *Channel {
	return &Channel{
		ChannelName:       m.ChannelName,
		Etag:              m.Etag,
		Location:          m.Location,
		ProvisioningState: m.ProvisioningState,
	}
}

// MsTeamsChannel - Microsoft Teams channel definition
type MsTeamsChannel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to Microsoft Teams channel resource
	Properties *MsTeamsChannelProperties

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type MsTeamsChannel.
func (m *MsTeamsChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       m.ChannelName,
		Etag:              m.Etag,
		Location:          m.Location,
		ProvisioningState: m.ProvisioningState,
	}
}

// MsTeamsChannelProperties - The parameters to provide for the Microsoft Teams channel.
type MsTeamsChannelProperties struct {
	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool

	// Whether this channel accepted terms
	AcceptedTerms *bool

	// Webhook for Microsoft Teams channel calls
	CallingWebhook *string

	// Deployment environment for Microsoft Teams channel calls
	DeploymentEnvironment *string

	// Enable calling for Microsoft Teams channel
	EnableCalling *bool

	// Webhook for Microsoft Teams channel calls
	IncomingCallRoute *string
}

// Omnichannel channel definition
type Omnichannel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type Omnichannel.
func (o *Omnichannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       o.ChannelName,
		Etag:              o.Etag,
		Location:          o.Location,
		ProvisioningState: o.ProvisioningState,
	}
}

// OperationDisplayInfo - The operation supported by Bot Service Management.
type OperationDisplayInfo struct {
	// The description of the operation.
	Description *string

	// The action that users can perform, based on their permission level.
	Operation *string

	// Service provider: Microsoft Bot Service.
	Provider *string

	// Resource on which the operation is performed.
	Resource *string
}

// OperationEntity - The operations supported by Bot Service Management.
type OperationEntity struct {
	// The operation supported by Bot Service Management.
	Display *OperationDisplayInfo

	// Operation name: {provider}/{resource}/{operation}.
	Name *string

	// The origin of the operation.
	Origin *string

	// Additional properties.
	Properties any
}

// OperationEntityListResult - The list of bot service operation response.
type OperationEntityListResult struct {
	// The link used to get the next page of operations.
	NextLink *string

	// The list of operations.
	Value []*OperationEntity
}

// OperationResultsDescription - The properties indicating the operation result of an operation on a service.
type OperationResultsDescription struct {
	// READ-ONLY; The ID of the operation returned.
	ID *string

	// READ-ONLY; The name of the operation result.
	Name *string

	// READ-ONLY; The time that the operation was started.
	StartTime *time.Time

	// READ-ONLY; The status of the operation being performed.
	Status *OperationResultStatus
}

// OutlookChannel - Outlook channel definition
type OutlookChannel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type OutlookChannel.
func (o *OutlookChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       o.ChannelName,
		Etag:              o.Etag,
		Location:          o.Location,
		ProvisioningState: o.ProvisioningState,
	}
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// Group ids
	GroupIDs []*string

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceBase - Common fields that are returned in the response for all BotService Private Link Resources
type PrivateLinkResourceBase struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string

	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string

	// The reason for approval/rejection of the connection.
	Description *string

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus
}

// QnAMakerEndpointKeysRequestBody - The request body for a request to Bot Service Management to list QnA Maker endpoint keys.
type QnAMakerEndpointKeysRequestBody struct {
	// Subscription key which provides access to this API.
	Authkey *string

	// the host name of the QnA Maker endpoint
	Hostname *string
}

// QnAMakerEndpointKeysResponse - Schema for EndpointKeys generate/refresh operations.
type QnAMakerEndpointKeysResponse struct {
	// Current version of runtime.
	InstalledVersion *string

	// Latest version of runtime.
	LastStableVersion *string

	// Primary Access Key.
	PrimaryEndpointKey *string

	// Secondary Access Key.
	SecondaryEndpointKey *string
}

// Resource - Azure resource
type Resource struct {
	// Entity Tag
	Etag *string

	// Required. Gets or sets the Kind of the resource.
	Kind *Kind

	// Specifies the location of the resource.
	Location *string

	// Gets or sets the SKU of the resource.
	SKU *SKU

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string

	// READ-ONLY; Specifies the resource ID.
	ID *string

	// READ-ONLY; Specifies the name of the resource.
	Name *string

	// READ-ONLY; Specifies the type of the resource.
	Type *string

	// READ-ONLY; Entity zones
	Zones []*string
}

// SKU - The SKU of the cognitive services account.
type SKU struct {
	// REQUIRED; The sku name
	Name *SKUName

	// READ-ONLY; Gets the sku tier. This is based on the SKU name.
	Tier *SKUTier
}

// SearchAssistant definition
type SearchAssistant struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type SearchAssistant.
func (s *SearchAssistant) GetChannel() *Channel {
	return &Channel{
		ChannelName:       s.ChannelName,
		Etag:              s.Etag,
		Location:          s.Location,
		ProvisioningState: s.ProvisioningState,
	}
}

// ServiceProvider - Service Provider Definition
type ServiceProvider struct {
	// The Properties of a Service Provider Object
	Properties *ServiceProviderProperties
}

// ServiceProviderParameter - Extra Parameters specific to each Service Provider
type ServiceProviderParameter struct {
	// READ-ONLY; Default Name for the Service Provider
	Default *string

	// READ-ONLY; Description of the Service Provider
	Description *string

	// READ-ONLY; Display Name of the Service Provider
	DisplayName *string

	// READ-ONLY; Help Url for the Service Provider
	HelpURL *string

	// READ-ONLY; Meta data for the Service Provider
	Metadata *ServiceProviderParameterMetadata

	// READ-ONLY; Name of the Service Provider
	Name *string

	// READ-ONLY; Type of the Service Provider
	Type *string
}

// ServiceProviderParameterMetadata - Meta data for the Service Provider
type ServiceProviderParameterMetadata struct {
	// the constraints of the bot meta data.
	Constraints *ServiceProviderParameterMetadataConstraints
}

// ServiceProviderParameterMetadataConstraints - the constraints of the bot meta data.
type ServiceProviderParameterMetadataConstraints struct {
	// Whether required the constraints of the bot meta data.
	Required *bool
}

// ServiceProviderProperties - The Object used to describe a Service Provider supported by Bot Service
type ServiceProviderProperties struct {
	// The URL of icon
	IconURL *string

	// The list of parameters for the Service Provider
	Parameters []*ServiceProviderParameter

	// READ-ONLY; URL of Dev Portal
	DevPortalURL *string

	// READ-ONLY; Display Name of the Service Provider
	DisplayName *string

	// READ-ONLY; Id for Service Provider
	ID *string

	// READ-ONLY; Name of the Service Provider
	ServiceProviderName *string
}

// ServiceProviderResponseList - The list of bot service providers response.
type ServiceProviderResponseList struct {
	// The link used to get the next page of bot service providers.
	NextLink *string

	// READ-ONLY; Gets the list of bot service providers and their properties.
	Value []*ServiceProvider
}

// Site - A site for the channel
type Site struct {
	// REQUIRED; Whether this site is enabled for DirectLine channel
	IsEnabled *bool

	// REQUIRED; Site name
	SiteName *string

	// DirectLine application id
	AppID *string

	// Entity Tag
	ETag *string

	// Whether this site is enabled for block user upload.
	IsBlockUserUploadEnabled *bool

	// Whether this site is disabled detailed logging for
	IsDetailedLoggingEnabled *bool

	// Whether this site is EndpointParameters enabled for channel
	IsEndpointParametersEnabled *bool

	// Whether this no-storage site is disabled detailed logging for
	IsNoStorageEnabled *bool

	// Whether this site is enabled for authentication with Bot Framework.
	IsSecureSiteEnabled *bool

	// Whether this site is enabled for Bot Framework V1 protocol.
	IsV1Enabled *bool

	// Whether this site is enabled for Bot Framework V3 protocol.
	IsV3Enabled *bool

	// Whether this site is enabled for Webchat Speech
	IsWebChatSpeechEnabled *bool

	// Whether this site is enabled for preview versions of Webchat
	IsWebchatPreviewEnabled *bool

	// Tenant Id
	TenantID *string

	// List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
	TrustedOrigins []*string

	// READ-ONLY; Whether this site is token enabled for channel
	IsTokenEnabled *bool

	// READ-ONLY; Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key *string

	// READ-ONLY; Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key2 *string

	// READ-ONLY; Site Id
	SiteID *string
}

// SiteInfo - Site information for WebChat or DirectLine Channels to identify which site to regenerate keys for.
type SiteInfo struct {
	// REQUIRED; Determines which key is to be regenerated
	Key *Key

	// REQUIRED; The site name
	SiteName *string
}

// SkypeChannel - Skype channel definition
type SkypeChannel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to Skype channel resource
	Properties *SkypeChannelProperties

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type SkypeChannel.
func (s *SkypeChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       s.ChannelName,
		Etag:              s.Etag,
		Location:          s.Location,
		ProvisioningState: s.ProvisioningState,
	}
}

// SkypeChannelProperties - The parameters to provide for the Microsoft Teams channel.
type SkypeChannelProperties struct {
	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool

	// Calling web hook for Skype channel
	CallingWebHook *string

	// Enable calling for Skype channel
	EnableCalling *bool

	// Enable groups for Skype channel
	EnableGroups *bool

	// Enable media cards for Skype channel
	EnableMediaCards *bool

	// Enable messaging for Skype channel
	EnableMessaging *bool

	// Enable screen sharing for Skype channel
	EnableScreenSharing *bool

	// Enable video for Skype channel
	EnableVideo *bool

	// Group mode for Skype channel
	GroupsMode *string

	// Incoming call route for Skype channel
	IncomingCallRoute *string
}

// SlackChannel - Slack channel definition
type SlackChannel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to Slack channel resource
	Properties *SlackChannelProperties

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type SlackChannel.
func (s *SlackChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       s.ChannelName,
		Etag:              s.Etag,
		Location:          s.Location,
		ProvisioningState: s.ProvisioningState,
	}
}

// SlackChannelProperties - The parameters to provide for the Slack channel.
type SlackChannelProperties struct {
	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool

	// The Slack client id
	ClientID *string

	// The Slack client secret. Value only returned through POST to the action Channel List API, otherwise empty.
	ClientSecret *string

	// The Slack landing page Url
	LandingPageURL *string

	// Whether to register the settings before OAuth validation is performed. Recommended to True.
	RegisterBeforeOAuthFlow *bool

	// The Slack permission scopes.
	Scopes *string

	// The Slack signing secret.
	SigningSecret *string

	// The Slack verification token. Value only returned through POST to the action Channel List API, otherwise empty.
	VerificationToken *string

	// READ-ONLY; Whether this channel is validated for the bot
	IsValidated *bool

	// READ-ONLY; The Sms auth token
	LastSubmissionID *string

	// READ-ONLY; The Slack redirect action
	RedirectAction *string
}

// SmsChannel - Sms channel definition
type SmsChannel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to Sms channel resource
	Properties *SmsChannelProperties

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type SmsChannel.
func (s *SmsChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       s.ChannelName,
		Etag:              s.Etag,
		Location:          s.Location,
		ProvisioningState: s.ProvisioningState,
	}
}

// SmsChannelProperties - The parameters to provide for the Sms channel.
type SmsChannelProperties struct {
	// REQUIRED; The Sms account SID. Value only returned through POST to the action Channel List API, otherwise empty.
	AccountSID *string

	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool

	// REQUIRED; The Sms phone
	Phone *string

	// The Sms auth token. Value only returned through POST to the action Channel List API, otherwise empty.
	AuthToken *string

	// Whether this channel is validated for the bot
	IsValidated *bool
}

// TelegramChannel - Telegram channel definition
type TelegramChannel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to Telegram channel resource
	Properties *TelegramChannelProperties

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type TelegramChannel.
func (t *TelegramChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       t.ChannelName,
		Etag:              t.Etag,
		Location:          t.Location,
		ProvisioningState: t.ProvisioningState,
	}
}

// TelegramChannelProperties - The parameters to provide for the Telegram channel.
type TelegramChannelProperties struct {
	// REQUIRED; Whether this channel is enabled for the bot
	IsEnabled *bool

	// The Telegram access token. Value only returned through POST to the action Channel List API, otherwise empty.
	AccessToken *string

	// Whether this channel is validated for the bot
	IsValidated *bool
}

// TelephonyChannel - Telephony channel definition
type TelephonyChannel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to Telephony channel resource
	Properties *TelephonyChannelProperties

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type TelephonyChannel.
func (t *TelephonyChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       t.ChannelName,
		Etag:              t.Etag,
		Location:          t.Location,
		ProvisioningState: t.ProvisioningState,
	}
}

// TelephonyChannelProperties - The parameters to provide for the Direct Line channel.
type TelephonyChannelProperties struct {
	// The list of Telephony api configuration
	APIConfigurations []*TelephonyChannelResourceAPIConfiguration

	// The extensionKey2
	CognitiveServiceRegion *string

	// The extensionKey1
	CognitiveServiceSubscriptionKey *string

	// The default locale of the channel
	DefaultLocale *string

	// Whether the channel is enabled
	IsEnabled *bool

	// The list of Telephony phone numbers
	PhoneNumbers []*TelephonyPhoneNumbers

	// The premium SKU applied to the channel
	PremiumSKU *string
}

// TelephonyChannelResourceAPIConfiguration - A resource Api configuration for the Telephony channel
type TelephonyChannelResourceAPIConfiguration struct {
	// The cognitive service region.
	CognitiveServiceRegion *string

	// The cognitive service resourceId.
	CognitiveServiceResourceID *string

	// The cognitive service subscription key.
	CognitiveServiceSubscriptionKey *string

	// The default locale.
	DefaultLocale *string

	// The id of config.
	ID *string

	// The provider name.
	ProviderName *string
}

// TelephonyPhoneNumbers - A telephone number for the Telephony channel
type TelephonyPhoneNumbers struct {
	// The endpoint of ACS.
	AcsEndpoint *string

	// The resource id of ACS.
	AcsResourceID *string

	// The secret of ACS.
	AcsSecret *string

	// The service region of cognitive service.
	CognitiveServiceRegion *string

	// The resource id of cognitive service.
	CognitiveServiceResourceID *string

	// The subscription key of cognitive service.
	CognitiveServiceSubscriptionKey *string

	// The default locale of the phone number.
	DefaultLocale *string

	// The element id.
	ID *string

	// Optional Property that will determine the offering type of the phone.
	OfferType *string

	// The phone number.
	PhoneNumber *string
}

// WebChatChannel - Web Chat channel definition
type WebChatChannel struct {
	// REQUIRED; The channel name
	ChannelName *string

	// Entity Tag of the resource
	Etag *string

	// Specifies the location of the resource.
	Location *string

	// The set of properties specific to Web Chat channel resource
	Properties *WebChatChannelProperties

	// READ-ONLY; Provisioning state of the resource
	ProvisioningState *string
}

// GetChannel implements the ChannelClassification interface for type WebChatChannel.
func (w *WebChatChannel) GetChannel() *Channel {
	return &Channel{
		ChannelName:       w.ChannelName,
		Etag:              w.Etag,
		Location:          w.Location,
		ProvisioningState: w.ProvisioningState,
	}
}

// WebChatChannelProperties - The parameters to provide for the Web Chat channel.
type WebChatChannelProperties struct {
	// The list of Web Chat sites
	Sites []*WebChatSite

	// READ-ONLY; Web chat control embed code
	WebChatEmbedCode *string
}

// WebChatSite - A site for the Webchat channel
type WebChatSite struct {
	// REQUIRED; Whether this site is enabled for DirectLine channel
	IsEnabled *bool

	// REQUIRED; Site name
	SiteName *string

	// DirectLine application id
	AppID *string

	// Entity Tag
	ETag *string

	// Whether this site is enabled for block user upload.
	IsBlockUserUploadEnabled *bool

	// Whether this site is disabled detailed logging for
	IsDetailedLoggingEnabled *bool

	// Whether this site is EndpointParameters enabled for channel
	IsEndpointParametersEnabled *bool

	// Whether this no-storage site is disabled detailed logging for
	IsNoStorageEnabled *bool

	// Whether this site is enabled for authentication with Bot Framework.
	IsSecureSiteEnabled *bool

	// Whether this site is enabled for Bot Framework V1 protocol.
	IsV1Enabled *bool

	// Whether this site is enabled for Bot Framework V3 protocol.
	IsV3Enabled *bool

	// Whether this site is enabled for Webchat Speech
	IsWebChatSpeechEnabled *bool

	// Whether this site is enabled for preview versions of Webchat
	IsWebchatPreviewEnabled *bool

	// Tenant Id
	TenantID *string

	// List of Trusted Origin URLs for this site. This field is applicable only if isSecureSiteEnabled is True.
	TrustedOrigins []*string

	// READ-ONLY; Whether this site is token enabled for channel
	IsTokenEnabled *bool

	// READ-ONLY; Primary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key *string

	// READ-ONLY; Secondary key. Value only returned through POST to the action Channel List API, otherwise empty.
	Key2 *string

	// READ-ONLY; Site Id
	SiteID *string
}
