{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FEventAddTrimmingContour: TMFNodeEvent;
    {  }
    public property EventAddTrimmingContour: TMFNodeEvent read FEventAddTrimmingContour;

    strict private FEventRemoveTrimmingContour: TMFNodeEvent;
    {  }
    public property EventRemoveTrimmingContour: TMFNodeEvent read FEventRemoveTrimmingContour;

    strict private FFdTrimmingContour: TMFNode;
    { Internal wrapper for property @link(TrimmingContour). This wrapper API may change, we advise to access simpler @link(TrimmingContour) instead. }
    public property FdTrimmingContour: TMFNode read FFdTrimmingContour;
    {  }
    procedure SetTrimmingContour(const Value: array of TContour2DNode);

{$endif read_interface}

{$ifdef read_implementation}

{ TNurbsTrimmedSurfaceNode ----------------------------------------------- }

procedure TNurbsTrimmedSurfaceNode.SetTrimmingContour(const Value: array of TContour2DNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TContour2DNode));
  FdTrimmingContour.Send(A);
end;

class function TNurbsTrimmedSurfaceNode.ClassX3DType: String;
begin
  Result := 'NurbsTrimmedSurface';
end;

procedure TNurbsTrimmedSurfaceNode.CreateNode;
begin
  inherited;

  FEventAddTrimmingContour := TMFNodeEvent.Create(Self, 'addTrimmingContour', true);
  AddEvent(FEventAddTrimmingContour);

  FEventRemoveTrimmingContour := TMFNodeEvent.Create(Self, 'removeTrimmingContour', true);
  AddEvent(FEventRemoveTrimmingContour);

  FFdTrimmingContour := TMFNode.Create(Self, True, 'trimmingContour', [TContour2DNode]);
   FdTrimmingContour.ChangeAlways := chGeometry;
  AddField(FFdTrimmingContour);
end;

{$endif read_implementation}
