{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdValue: TMFMatrix4f;
    { Internal wrapper for property @link(Value). This wrapper API may change, we advise to access simpler @link(Value) instead. }
    public property FdValue: TMFMatrix4f read FFdValue;
    {  }
    procedure SetValue(const Value: array of TMatrix4); overload;
    {  }
    procedure SetValue(const Value: TMatrix4List); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TMatrix4VertexAttributeNode ----------------------------------------------- }

procedure TMatrix4VertexAttributeNode.SetValue(const Value: array of TMatrix4);
begin
  FdValue.Send(Value);
end;

procedure TMatrix4VertexAttributeNode.SetValue(const Value: TMatrix4List);
begin
  FdValue.Send(Value);
end;

class function TMatrix4VertexAttributeNode.ClassX3DType: String;
begin
  Result := 'Matrix4VertexAttribute';
end;

procedure TMatrix4VertexAttributeNode.CreateNode;
begin
  inherited;

  FFdValue := TMFMatrix4f.Create(Self, True, 'value', []);
   FdValue.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdValue);
end;

{$endif read_implementation}
